/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.QuerySubmitter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.Allow;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.consent.InteractionResultSet;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.apache.isis.core.metamodel.facets.TypedHolder;
import org.apache.isis.core.metamodel.facets.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.param.autocomplete.ActionParameterAutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionParameterChoicesFacet;
import org.apache.isis.core.metamodel.facets.param.defaults.ActionParameterDefaultsFacet;
import org.apache.isis.core.metamodel.interactions.ActionArgumentContext;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.spec.DomainModelException;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionImpl;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectMemberAbstract;

public abstract class ObjectActionParameterAbstract
implements ObjectActionParameter {
    private final int number;
    private final ObjectActionImpl parentAction;
    private final TypedHolder peer;

    protected ObjectActionParameterAbstract(int number, ObjectActionImpl objectAction, TypedHolder peer) {
        this.number = number;
        this.parentAction = objectAction;
        this.peer = peer;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public ObjectAction getAction() {
        return this.parentAction;
    }

    public TypedHolder getPeer() {
        return this.peer;
    }

    @Override
    public ObjectSpecification getSpecification() {
        return ObjectMemberAbstract.getSpecification(this.getSpecificationLookup(), this.peer.getType());
    }

    @Override
    public Identifier getIdentifier() {
        return this.parentAction.getIdentifier();
    }

    @Override
    public String getId() {
        NamedFacet facet = this.getFacet(NamedFacet.class);
        if (facet != null && facet.value() != null) {
            return StringExtensions.asCamelLowerFirst(facet.value());
        }
        String name = this.getSpecification().getSingularName();
        List<ObjectActionParameter> parameters = this.getAction().getParameters(new Filter<ObjectActionParameter>(){

            public boolean accept(ObjectActionParameter t) {
                return this.equalsShortIdentifier(t.getSpecification(), ObjectActionParameterAbstract.this.getSpecification());
            }

            protected boolean equalsShortIdentifier(ObjectSpecification spec1, ObjectSpecification spec2) {
                return spec1.getShortIdentifier().toLowerCase().equals(spec2.getShortIdentifier().toLowerCase());
            }
        });
        if (parameters.size() == 1) {
            return StringExtensions.asCamelLowerFirst(name);
        }
        int indexOf = parameters.indexOf(this);
        return StringExtensions.asCamelLowerFirst(name + (indexOf + 1));
    }

    @Override
    public String getName() {
        NamedFacet facet = this.getFacet(NamedFacet.class);
        if (facet != null && facet.value() != null) {
            return facet.value();
        }
        String name = this.getSpecification().getSingularName();
        List<ObjectActionParameter> parameters = this.getAction().getParameters(new Filter<ObjectActionParameter>(){

            public boolean accept(ObjectActionParameter t) {
                return this.equalsShortIdentifier(t.getSpecification(), ObjectActionParameterAbstract.this.getSpecification());
            }

            protected boolean equalsShortIdentifier(ObjectSpecification spec1, ObjectSpecification spec2) {
                return spec1.getShortIdentifier().toLowerCase().equals(spec2.getShortIdentifier().toLowerCase());
            }
        });
        if (parameters.size() == 1) {
            return name;
        }
        int indexOf = parameters.indexOf(this);
        return name + " " + (indexOf + 1);
    }

    @Override
    public String getDescription() {
        DescribedAsFacet facet = this.getFacet(DescribedAsFacet.class);
        String description = facet.value();
        return description == null ? "" : description;
    }

    @Override
    public boolean isOptional() {
        MandatoryFacet facet = this.getFacet(MandatoryFacet.class);
        return facet.isInvertedSemantics();
    }

    public Consent isUsable() {
        return Allow.DEFAULT;
    }

    @Override
    public boolean containsFacet(Class<? extends Facet> facetType) {
        return this.peer != null ? this.peer.containsFacet(facetType) : false;
    }

    @Override
    public boolean containsDoOpFacet(Class<? extends Facet> facetType) {
        return this.peer == null ? false : this.peer.containsDoOpFacet(facetType);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> cls) {
        return this.peer != null ? (T)this.peer.getFacet(cls) : null;
    }

    @Override
    public Class<? extends Facet>[] getFacetTypes() {
        return this.peer != null ? this.peer.getFacetTypes() : new Class[]{};
    }

    @Override
    public List<Facet> getFacets(Filter<Facet> filter) {
        return this.peer != null ? this.peer.getFacets(filter) : Lists.newArrayList();
    }

    @Override
    public void addFacet(Facet facet) {
        if (this.peer != null) {
            this.peer.addFacet(facet);
        }
    }

    @Override
    public void addFacet(MultiTypedFacet facet) {
        if (this.peer != null) {
            this.peer.addFacet(facet);
        }
    }

    @Override
    public void removeFacet(Facet facet) {
        if (this.peer != null) {
            this.peer.removeFacet(facet);
        }
    }

    @Override
    public void removeFacet(Class<? extends Facet> facetType) {
        if (this.peer != null) {
            this.peer.removeFacet(facetType);
        }
    }

    @Override
    public boolean hasAutoComplete() {
        ActionParameterAutoCompleteFacet facet = this.getFacet(ActionParameterAutoCompleteFacet.class);
        return facet != null;
    }

    @Override
    public ObjectAdapter[] getAutoComplete(ObjectAdapter adapter, String searchArg) {
        ArrayList adapters = Lists.newArrayList();
        ActionParameterAutoCompleteFacet facet = this.getFacet(ActionParameterAutoCompleteFacet.class);
        if (facet != null) {
            Object[] choices = facet.autoComplete(adapter, searchArg);
            ObjectActionParameterAbstract.checkChoicesOrAutoCompleteType(this.getSpecificationLookup(), choices, this.getSpecification());
            for (Object choice : choices) {
                adapters.add(this.getAdapterMap().adapterFor(choice));
            }
        }
        return adapters.toArray(new ObjectAdapter[0]);
    }

    @Override
    public int getAutoCompleteMinLength() {
        ActionParameterAutoCompleteFacet facet = this.getFacet(ActionParameterAutoCompleteFacet.class);
        return facet != null ? facet.getMinLength() : 1;
    }

    @Override
    public boolean hasChoices() {
        ActionParameterChoicesFacet choicesFacet = this.getFacet(ActionParameterChoicesFacet.class);
        return choicesFacet != null;
    }

    @Override
    public ObjectAdapter[] getChoices(ObjectAdapter adapter, ObjectAdapter[] argumentsIfAvailable) {
        List<ObjectAdapter> argListIfAvailable = ListExtensions.mutableCopy(argumentsIfAvailable);
        ObjectAdapter target = this.targetForDefaultOrChoices(adapter, argListIfAvailable);
        List<ObjectAdapter> args = this.argsForDefaultOrChoices(adapter, argListIfAvailable);
        return this.findChoices(target, args);
    }

    private ObjectAdapter[] findChoices(ObjectAdapter target, List<ObjectAdapter> args) {
        ArrayList adapters = Lists.newArrayList();
        ActionParameterChoicesFacet facet = this.getFacet(ActionParameterChoicesFacet.class);
        if (facet != null) {
            Object[] choices = facet.getChoices(target, args);
            ObjectActionParameterAbstract.checkChoicesOrAutoCompleteType(this.getSpecificationLookup(), choices, this.getSpecification());
            for (Object choice : choices) {
                ObjectAdapter adapter = choice != null ? this.getAdapterMap().adapterFor(choice) : null;
                adapters.add(adapter);
            }
        }
        return adapters.toArray(new ObjectAdapter[0]);
    }

    @Override
    public ObjectAdapter getDefault(ObjectAdapter adapter) {
        ObjectAdapter target = this.targetForDefaultOrChoices(adapter, null);
        List<ObjectAdapter> args = this.argsForDefaultOrChoices(adapter, null);
        return this.findDefault(target, args);
    }

    private ObjectAdapter findDefault(ObjectAdapter target, List<ObjectAdapter> args) {
        ActionParameterDefaultsFacet defaultsFacet = this.getFacet(ActionParameterDefaultsFacet.class);
        if (defaultsFacet != null) {
            Object dflt = defaultsFacet.getDefault(target, args);
            if (dflt == null) {
                return null;
            }
            return this.getAdapterMap().adapterFor(dflt);
        }
        return null;
    }

    protected ObjectAdapter targetForDefaultOrChoices(ObjectAdapter adapter, List<ObjectAdapter> argumentsIfAvailable) {
        return adapter;
    }

    protected List<ObjectAdapter> argsForDefaultOrChoices(ObjectAdapter adapter, List<ObjectAdapter> argumentsIfAvailable) {
        return argumentsIfAvailable;
    }

    static void checkChoicesOrAutoCompleteType(SpecificationLoader specificationLookup, Object[] objects, ObjectSpecification paramSpec) {
        for (Object object : objects) {
            ObjectSpecification paramWrappedSpec;
            if (object == null) continue;
            Class<?> choiceClass = object.getClass();
            Class<?> paramClass = paramSpec.getCorrespondingClass();
            Class<? extends Object> choiceWrappedClass = ClassExtensions.asWrappedIfNecessary(choiceClass);
            Class<? extends Object> paramWrappedClass = ClassExtensions.asWrappedIfNecessary(paramClass);
            ObjectSpecification choiceWrappedSpec = specificationLookup.loadSpecification(choiceWrappedClass);
            if (choiceWrappedSpec.isOfType(paramWrappedSpec = specificationLookup.loadSpecification(paramWrappedClass))) continue;
            throw new DomainModelException("Type incompatible with parameter type; expected " + paramSpec.getFullIdentifier() + ", but was " + choiceClass.getName());
        }
    }

    private <T> void addAllInstancesForType(List<ObjectAdapter> adapters) {
        QueryFindAllInstances query = new QueryFindAllInstances(this.getSpecification().getFullIdentifier(), new long[0]);
        List<ObjectAdapter> allInstancesAdapter = this.getQuerySubmitter().allMatchingQuery(query);
        for (ObjectAdapter choiceAdapter : allInstancesAdapter) {
            adapters.add(choiceAdapter);
        }
    }

    @Override
    public ActionArgumentContext createProposedArgumentInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, ObjectAdapter targetObject, ObjectAdapter[] proposedArguments, int position) {
        return new ActionArgumentContext(this.getDeploymentCategory(), this.getAuthenticationSession(), invocationMethod, targetObject, this.getIdentifier(), proposedArguments, position);
    }

    @Override
    public String isValid(ObjectAdapter adapter, Object proposedValue, Localization localization) {
        ObjectAdapter proposedValueAdapter = null;
        if (proposedValue != null) {
            proposedValueAdapter = this.getAdapterMap().adapterFor(proposedValue);
            ObjectSpecification proposedValueSpec = proposedValueAdapter.getSpecification();
            if (!proposedValueSpec.isOfType(proposedValueSpec)) {
                proposedValueAdapter = this.doCoerceProposedValue(adapter, proposedValue, localization);
            }
            if (proposedValueAdapter == null) {
                return null;
            }
            proposedValueSpec = proposedValueAdapter.getSpecification();
            if (!proposedValueSpec.isOfType(proposedValueSpec)) {
                return null;
            }
        }
        ActionArgumentContext ic = this.createProposedArgumentInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, adapter, this.arguments(proposedValueAdapter), this.getNumber());
        InteractionResultSet buf = new InteractionResultSet();
        InteractionUtils.isValidResultSet(this, ic, buf);
        if (buf.isVetoed()) {
            return buf.getInteractionResult().getReason();
        }
        return null;
    }

    protected ObjectAdapter doCoerceProposedValue(ObjectAdapter adapter, Object proposedValue, Localization localization) {
        return null;
    }

    private ObjectAdapter[] arguments(ObjectAdapter proposedValue) {
        int parameterCount = this.getAction().getParameterCount();
        ObjectAdapter[] arguments = new ObjectAdapter[parameterCount];
        arguments[this.getNumber()] = proposedValue;
        return arguments;
    }

    private DeploymentCategory getDeploymentCategory() {
        return this.parentAction.getDeploymentCategory();
    }

    protected SpecificationLoader getSpecificationLookup() {
        return this.parentAction.getSpecificationLookup();
    }

    protected AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.parentAction.getAuthenticationSessionProvider();
    }

    protected AdapterManager getAdapterMap() {
        return this.parentAction.getAdapterManager();
    }

    protected QuerySubmitter getQuerySubmitter() {
        return this.parentAction.getQuerySubmitter();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.getAuthenticationSessionProvider().getAuthenticationSession();
    }
}

