/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.QuerySubmitter;
import org.apache.isis.core.metamodel.adapter.ServicesProvider;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.help.HelpFacet;
import org.apache.isis.core.metamodel.facets.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.named.NamedFacet;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.ObjectMemberContext;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;

public abstract class ObjectMemberAbstract
implements ObjectMember {
    protected final String defaultName;
    private final String id;
    private final FacetedMethod facetedMethod;
    private final FeatureType featureType;
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final SpecificationLoader specificationLookup;
    private final AdapterManager adapterManager;
    private final ServicesProvider servicesProvider;
    private final QuerySubmitter querySubmitter;
    private final CollectionTypeRegistry collectionTypeRegistry;
    private final DeploymentCategory deploymentCategory;

    public static ObjectSpecification getSpecification(SpecificationLoader specificationLookup, Class<?> type) {
        return type == null ? null : specificationLookup.loadSpecification(type);
    }

    protected ObjectMemberAbstract(FacetedMethod facetedMethod, FeatureType featureType, ObjectMemberContext objectMemberContext) {
        String id = facetedMethod.getIdentifier().getMemberName();
        if (id == null) {
            throw new IllegalArgumentException("Name must always be set");
        }
        this.facetedMethod = facetedMethod;
        this.featureType = featureType;
        this.id = id;
        this.defaultName = StringExtensions.asNaturalName2(this.id);
        this.deploymentCategory = objectMemberContext.getDeploymentCategory();
        this.authenticationSessionProvider = objectMemberContext.getAuthenticationSessionProvider();
        this.specificationLookup = objectMemberContext.getSpecificationLookup();
        this.adapterManager = objectMemberContext.getAdapterManager();
        this.servicesProvider = objectMemberContext.getServicesProvider();
        this.querySubmitter = objectMemberContext.getQuerySubmitter();
        this.collectionTypeRegistry = objectMemberContext.getCollectionTypeRegistry();
    }

    public DeploymentCategory getDeploymentCategory() {
        return this.deploymentCategory;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public FacetedMethod getFacetedMethod() {
        return this.facetedMethod;
    }

    @Override
    public Identifier getIdentifier() {
        return this.getFacetedMethod().getIdentifier();
    }

    @Override
    public FeatureType getFeatureType() {
        return this.featureType;
    }

    @Override
    public boolean containsFacet(Class<? extends Facet> facetType) {
        return this.getFacetedMethod().containsFacet(facetType);
    }

    @Override
    public boolean containsDoOpFacet(Class<? extends Facet> facetType) {
        return this.getFacetedMethod().containsDoOpFacet(facetType);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> cls) {
        return this.getFacetedMethod().getFacet(cls);
    }

    @Override
    public Class<? extends Facet>[] getFacetTypes() {
        return this.getFacetedMethod().getFacetTypes();
    }

    @Override
    public List<Facet> getFacets(Filter<Facet> filter) {
        return this.getFacetedMethod().getFacets(filter);
    }

    @Override
    public void addFacet(Facet facet) {
        this.getFacetedMethod().addFacet(facet);
    }

    @Override
    public void addFacet(MultiTypedFacet facet) {
        this.getFacetedMethod().addFacet(facet);
    }

    @Override
    public void removeFacet(Facet facet) {
        this.getFacetedMethod().removeFacet(facet);
    }

    @Override
    public void removeFacet(Class<? extends Facet> facetType) {
        this.getFacetedMethod().removeFacet(facetType);
    }

    @Override
    public String getName() {
        NamedFacet facet = this.getFacet(NamedFacet.class);
        String name = facet.value();
        return name != null ? name : this.defaultName;
    }

    @Override
    public String getDescription() {
        DescribedAsFacet facet = this.getFacet(DescribedAsFacet.class);
        return facet.value();
    }

    @Override
    public String getHelp() {
        HelpFacet facet = this.getFacet(HelpFacet.class);
        return facet.value();
    }

    @Override
    public boolean isAlwaysHidden() {
        HiddenFacet hiddenFacet = this.getFacet(HiddenFacet.class);
        return hiddenFacet != null && hiddenFacet.when() == When.ALWAYS && hiddenFacet.where() == Where.ANYWHERE;
    }

    @Override
    public Consent isVisible(AuthenticationSession session, ObjectAdapter target, Where where) {
        return this.isVisibleResult(this.deploymentCategory, session, target, where).createConsent();
    }

    private InteractionResult isVisibleResult(DeploymentCategory deploymentCategory, AuthenticationSession session, ObjectAdapter target, Where where) {
        VisibilityContext<?> ic = this.createVisibleInteractionContext(session, InteractionInvocationMethod.BY_USER, target, where);
        return InteractionUtils.isVisibleResult(this, ic);
    }

    @Override
    public Consent isUsable(AuthenticationSession session, ObjectAdapter target, Where where) {
        return this.isUsableResult(session, target, where).createConsent();
    }

    private InteractionResult isUsableResult(AuthenticationSession session, ObjectAdapter target, Where where) {
        UsabilityContext<?> ic = this.createUsableInteractionContext(session, InteractionInvocationMethod.BY_USER, target, where);
        return InteractionUtils.isUsableResult(this, ic);
    }

    @Override
    public boolean isAction() {
        return this.featureType.isAction();
    }

    @Override
    public boolean isPropertyOrCollection() {
        return this.featureType.isPropertyOrCollection();
    }

    @Override
    public boolean isOneToManyAssociation() {
        return this.featureType.isCollection();
    }

    @Override
    public boolean isOneToOneAssociation() {
        return this.featureType.isProperty();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.authenticationSessionProvider.getAuthenticationSession();
    }

    public String toString() {
        return String.format("id=%s,name='%s'", this.getId(), this.getName());
    }

    public AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    public SpecificationLoader getSpecificationLookup() {
        return this.specificationLookup;
    }

    public AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    public ServicesProvider getServicesProvider() {
        return this.servicesProvider;
    }

    public QuerySubmitter getQuerySubmitter() {
        return this.querySubmitter;
    }

    public CollectionTypeRegistry getCollectionTypeRegistry() {
        return this.collectionTypeRegistry;
    }
}

