/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.actions.command.configuration;

import java.lang.reflect.Method;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Command;
import org.apache.isis.applib.services.HasTransactionId;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacet;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;
import org.apache.isis.core.progmodel.facets.actions.command.configuration.CommandFacetFromConfiguration;

public class CommandFromConfigurationFacetFactory
extends FacetFactoryAbstract
implements IsisConfigurationAware {
    private static final String COMMAND_ACTIONS_KEY = "isis.services.command.actions";
    private IsisConfiguration configuration;

    public CommandFromConfigurationFacetFactory() {
        super(FeatureType.ACTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        Class<?> cls = processMethodContext.getCls();
        Method method = processMethodContext.getMethod();
        ActionSemanticsFacet actionSemanticsFacet = facetHolder.getFacet(ActionSemanticsFacet.class);
        if (actionSemanticsFacet == null) {
            throw new IllegalStateException("Require ActionSemanticsFacet in order to process");
        }
        if (facetHolder.containsDoOpFacet(CommandFacet.class)) {
            return;
        }
        if (HasTransactionId.class.isAssignableFrom(cls)) {
            return;
        }
        ActionCategorization categorization = ActionCategorization.parse(this.configuration.getString(COMMAND_ACTIONS_KEY));
        if (categorization == ActionCategorization.NONE) {
            return;
        }
        if (actionSemanticsFacet.value() == ActionSemantics.Of.SAFE && categorization == ActionCategorization.IGNORE_SAFE) {
            return;
        }
        Command annotation = Annotations.getAnnotation(method, Command.class);
        FacetUtil.addFacet(this.create(annotation, facetHolder));
    }

    private CommandFacet create(Command annotation, FacetHolder holder) {
        return new CommandFacetFromConfiguration(Command.Persistence.PERSISTED, Command.ExecuteIn.FOREGROUND, holder);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    private static enum ActionCategorization {
        ALL,
        IGNORE_SAFE,
        NONE;


        public static ActionCategorization parse(String value) {
            if ("ignoreQueryOnly".equalsIgnoreCase(value) || "ignoreSafe".equalsIgnoreCase(value)) {
                return IGNORE_SAFE;
            }
            if ("all".equals(value)) {
                return ALL;
            }
            return NONE;
        }
    }
}

