/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.actions.invoke;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.annotation.Bulk;
import org.apache.isis.applib.annotation.Command;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.services.background.ActionInvocationMemento;
import org.apache.isis.applib.services.background.BackgroundService;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.command.spi.CommandService;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ThrowableExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacet;
import org.apache.isis.core.metamodel.facets.actions.invoke.ActionInvocationFacet;
import org.apache.isis.core.metamodel.facets.actions.invoke.ActionInvocationFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.publish.PublishedActionFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.facets.typeof.ElementSpecificationProviderFromTypeOfFacet;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.ReflectiveActionException;
import org.apache.isis.core.progmodel.facets.actions.bulk.BulkFacet;
import org.apache.isis.core.progmodel.facets.actions.invoke.CommandUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionInvocationFacetViaMethod
extends ActionInvocationFacetAbstract
implements ImperativeFacet {
    private static final Logger LOG = LoggerFactory.getLogger(ActionInvocationFacetViaMethod.class);
    private final Method method;
    private final ObjectSpecification onType;
    private final ObjectSpecification returnType;
    private final AdapterManager adapterManager;
    private final ServicesInjector servicesInjector;
    private final RuntimeContext runtimeContext;

    public ActionInvocationFacetViaMethod(Method method, ObjectSpecification onType, ObjectSpecification returnType, FacetHolder holder, RuntimeContext runtimeContext, AdapterManager adapterManager, ServicesInjector servicesInjector) {
        super(holder);
        this.method = method;
        this.onType = onType;
        this.returnType = returnType;
        this.runtimeContext = runtimeContext;
        this.adapterManager = adapterManager;
        this.servicesInjector = servicesInjector;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ObjectSpecification getReturnType() {
        return this.returnType;
    }

    @Override
    public ObjectSpecification getOnType() {
        return this.onType;
    }

    @Override
    public ObjectAdapter invoke(ObjectAdapter target, ObjectAdapter[] parameters) {
        return this.invoke(null, target, parameters);
    }

    @Override
    public ObjectAdapter invoke(ObjectAction owningAction, ObjectAdapter targetAdapter, ObjectAdapter[] arguments) {
        Bulk.InteractionContext bulkInteractionContext = this.getServicesInjector().lookupService(Bulk.InteractionContext.class);
        CommandContext commandContext = this.getServicesInjector().lookupService(CommandContext.class);
        Command command = commandContext != null ? commandContext.getCommand() : null;
        try {
            PublishedActionFacet publishedActionFacet;
            ObjectAdapter resultAdapter;
            Object[] executionParameters = new Object[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                executionParameters[i] = ActionInvocationFacetViaMethod.unwrap(arguments[i]);
            }
            Object object = ActionInvocationFacetViaMethod.unwrap(targetAdapter);
            BulkFacet bulkFacet = this.getFacetHolder().getFacet(BulkFacet.class);
            if (bulkFacet != null && bulkInteractionContext != null && bulkInteractionContext.getInvokedAs() == null) {
                bulkInteractionContext.setInvokedAs(Bulk.InteractionContext.InvokedAs.REGULAR);
                bulkInteractionContext.setDomainObjects(Collections.singletonList(object));
            }
            if (command != null && command.getExecutor() == Command.Executor.USER && owningAction != null) {
                CommandFacet commandFacet;
                command.setMemberIdentifier(CommandUtil.actionIdentifierFor(owningAction));
                command.setTargetClass(CommandUtil.targetClassNameFor(targetAdapter));
                command.setTargetAction(CommandUtil.targetActionNameFor(owningAction));
                command.setArguments(CommandUtil.argDescriptionFor(owningAction, arguments));
                Bookmark targetBookmark = CommandUtil.bookmarkFor(targetAdapter);
                command.setTarget(targetBookmark);
                BackgroundService backgroundService = this.getServicesInjector().lookupService(BackgroundService.class);
                if (backgroundService != null) {
                    Object[] args;
                    Object targetObject = ActionInvocationFacetViaMethod.unwrap(targetAdapter);
                    ActionInvocationMemento aim = backgroundService.asActionInvocationMemento(this.method, targetObject, args = CommandUtil.objectsFor(arguments));
                    if (aim != null) {
                        command.setMemento(aim.asMementoString());
                    } else {
                        throw new IsisException("Unable to build memento for action " + owningAction.getIdentifier().toClassAndNameIdentityString());
                    }
                }
                if ((commandFacet = this.getFacetHolder().getFacet(CommandFacet.class)) != null && !commandFacet.isDisabled()) {
                    command.setExecuteIn(commandFacet.executeIn());
                    command.setPersistence(commandFacet.persistence());
                } else {
                    command.setExecuteIn(Command.ExecuteIn.FOREGROUND);
                    command.setPersistence(Command.Persistence.IF_HINTED);
                }
            }
            if (command != null && command.getExecutor() == Command.Executor.USER && command.getExecuteIn() == Command.ExecuteIn.BACKGROUND) {
                CommandService commandService = this.getServicesInjector().lookupService(CommandService.class);
                if (commandService.persistIfPossible(command)) {
                    resultAdapter = this.getAdapterManager().adapterFor(command);
                    return resultAdapter;
                }
                throw new IsisException("Unable to schedule action '" + owningAction.getIdentifier().toClassAndNameIdentityString() + "' to run in background: " + "CommandService does not support persistent commands ");
            }
            if (command != null) {
                command.setStartedAt(Clock.getTimeAsJavaSqlTimestamp());
            }
            Object result = this.method.invoke(object, executionParameters);
            if (LOG.isDebugEnabled()) {
                LOG.debug(" action result " + result);
            }
            if (result == null) {
                return null;
            }
            resultAdapter = this.getAdapterManager().adapterFor(result);
            TypeOfFacet typeOfFacet = this.getFacetHolder().getFacet(TypeOfFacet.class);
            resultAdapter.setElementSpecificationProvider(ElementSpecificationProviderFromTypeOfFacet.createFrom(typeOfFacet));
            if (command != null && !resultAdapter.getSpecification().containsDoOpFacet(ViewModelFacet.class)) {
                Bookmark bookmark = CommandUtil.bookmarkFor(resultAdapter);
                command.setResult(bookmark);
            }
            ActionInvocationFacet.currentInvocation.set((publishedActionFacet = this.getIdentified().getFacet(PublishedActionFacet.class)) != null ? new ActionInvocationFacet.CurrentInvocation(targetAdapter, this.getIdentified(), arguments, resultAdapter, command) : null);
            return resultAdapter;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof IllegalStateException) {
                throw new ReflectiveActionException("IllegalStateException thrown while executing " + this.method + " " + targetException.getMessage(), targetException);
            }
            if (targetException instanceof RecoverableException && !this.runtimeContext.getTransactionState().canCommit()) {
                Throwable targetExceptionCause = targetException.getCause();
                Throwable nonRecoverableCause = targetExceptionCause != null ? targetExceptionCause : targetException;
                throw new NonRecoverableException(nonRecoverableCause);
            }
            ThrowableExtensions.throwWithinIsisException(e, "Exception executing " + this.method);
            return null;
        }
        catch (IllegalAccessException e) {
            throw new ReflectiveActionException("Illegal access of " + this.method, e);
        }
    }

    private static Object unwrap(ObjectAdapter adapter) {
        return adapter == null ? null : adapter.getObject();
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    private AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    private ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }
}

