/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.actions.typeof.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.isis.applib.annotation.TypeOf;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacetInferredFromArray;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacetInferredFromGenerics;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryAware;
import org.apache.isis.core.progmodel.facets.actions.typeof.annotation.TypeOfFacetAnnotationForAction;

public class TypeOfAnnotationForActionsFacetFactory
extends FacetFactoryAbstract
implements CollectionTypeRegistryAware {
    private CollectionTypeRegistry collectionTypeRegistry;

    public TypeOfAnnotationForActionsFacetFactory() {
        super(FeatureType.ACTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Class<?> methodReturnType = method.getReturnType();
        if (!this.collectionTypeRegistry.isCollectionType(methodReturnType) && !this.collectionTypeRegistry.isArrayType(methodReturnType)) {
            return;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType.isArray()) {
            Class<?> componentType = returnType.getComponentType();
            FacetUtil.addFacet(new TypeOfFacetInferredFromArray(componentType, (FacetHolder)processMethodContext.getFacetHolder(), this.getSpecificationLoader()));
            return;
        }
        TypeOf annotation = Annotations.getAnnotation(method, TypeOf.class);
        if (annotation != null) {
            FacetUtil.addFacet(new TypeOfFacetAnnotationForAction((Class<?>)annotation.value(), (FacetHolder)processMethodContext.getFacetHolder(), this.getSpecificationLoader()));
            return;
        }
        Type type = method.getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType methodParameterizedType = (ParameterizedType)type;
        Type[] methodActualTypeArguments = methodParameterizedType.getActualTypeArguments();
        if (methodActualTypeArguments.length == 0) {
            return;
        }
        Type methodActualTypeArgument = methodActualTypeArguments[0];
        if (methodActualTypeArgument instanceof Class) {
            Class actualType = (Class)methodActualTypeArgument;
            FacetUtil.addFacet(new TypeOfFacetInferredFromGenerics((Class<?>)actualType, (FacetHolder)processMethodContext.getFacetHolder(), this.getSpecificationLoader()));
            return;
        }
        if (methodActualTypeArgument instanceof TypeVariable) {
            ParameterizedType parameterizedTypeOfSuperclass;
            TypeVariable methodTypeVariable = (TypeVariable)methodActualTypeArgument;
            Object methodGenericClassDeclaration = methodTypeVariable.getGenericDeclaration();
            Type genericSuperclass = processMethodContext.getCls().getGenericSuperclass();
            if (genericSuperclass instanceof ParameterizedType && (parameterizedTypeOfSuperclass = (ParameterizedType)genericSuperclass).getRawType() == methodGenericClassDeclaration) {
                Type actualType;
                Type[] genericSuperClassActualTypeArguments = parameterizedTypeOfSuperclass.getActualTypeArguments();
                if (methodActualTypeArguments.length == 1 && (actualType = genericSuperClassActualTypeArguments[0]) instanceof Class) {
                    Class actualCls = (Class)actualType;
                    FacetUtil.addFacet(new TypeOfFacetInferredFromGenerics((Class<?>)actualCls, (FacetHolder)processMethodContext.getFacetHolder(), this.getSpecificationLoader()));
                    return;
                }
            }
            return;
        }
    }

    @Override
    public void setCollectionTypeRegistry(CollectionTypeRegistry collectionTypeRegistry) {
        this.collectionTypeRegistry = collectionTypeRegistry;
    }
}

