/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.collection;

import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacetDefaultToObject;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacetInferredFromArray;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacetInferredFromGenerics;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryAware;
import org.apache.isis.core.progmodel.facets.collections.collection.JavaArrayFacet;
import org.apache.isis.core.progmodel.facets.collections.collection.JavaCollectionFacet;

public class CollectionFacetFactory
extends FacetFactoryAbstract
implements CollectionTypeRegistryAware,
AdapterManagerAware {
    private CollectionTypeRegistry collectionTypeRegistry;
    private AdapterManager adapterManager;

    public CollectionFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        if (this.collectionTypeRegistry.isCollectionType(processClassContaxt.getCls())) {
            this.processCollectionType(processClassContaxt);
        } else if (this.collectionTypeRegistry.isArrayType(processClassContaxt.getCls())) {
            this.processAsArrayType(processClassContaxt);
        }
    }

    private void processCollectionType(FacetFactory.ProcessClassContext processClassContaxt) {
        TypeOfFacet facetHolder = processClassContaxt.getFacetHolder();
        TypeOfFacet typeOfFacet = facetHolder.getFacet(TypeOfFacet.class);
        if (typeOfFacet == null) {
            Class<?> collectionElementType = this.collectionElementType(processClassContaxt.getCls());
            facetHolder.addFacet(collectionElementType != Object.class ? new TypeOfFacetInferredFromGenerics(collectionElementType, (FacetHolder)((Object)facetHolder), this.getSpecificationLoader()) : new TypeOfFacetDefaultToObject((FacetHolder)((Object)facetHolder), this.getSpecificationLoader()));
        }
        facetHolder.addFacet(new JavaCollectionFacet((FacetHolder)((Object)facetHolder), this.getAdapterManager()));
    }

    private void processAsArrayType(FacetFactory.ProcessClassContext processClassContaxt) {
        Object facetHolder = processClassContaxt.getFacetHolder();
        facetHolder.addFacet(new JavaArrayFacet((FacetHolder)facetHolder, this.getAdapterManager()));
        facetHolder.addFacet(new TypeOfFacetInferredFromArray(processClassContaxt.getCls().getComponentType(), (FacetHolder)facetHolder, this.getSpecificationLoader()));
    }

    private Class<?> collectionElementType(Class<?> cls) {
        return Object.class;
    }

    @Override
    public void setCollectionTypeRegistry(CollectionTypeRegistry collectionTypeRegistry) {
        this.collectionTypeRegistry = collectionTypeRegistry;
    }

    public AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }
}

