/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.typeof;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.isis.applib.annotation.TypeOf;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacetInferredFromArray;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacetInferredFromGenerics;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryAware;
import org.apache.isis.core.progmodel.facets.collections.typeof.TypeOfFacetAnnotationForCollection;

public class TypeOfAnnotationForCollectionsFacetFactory
extends FacetFactoryAbstract
implements CollectionTypeRegistryAware {
    private CollectionTypeRegistry collectionTypeRegistry;

    public TypeOfAnnotationForCollectionsFacetFactory() {
        super(FeatureType.COLLECTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> methodReturnType = processMethodContext.getMethod().getReturnType();
        if (!this.collectionTypeRegistry.isCollectionType(methodReturnType) && !this.collectionTypeRegistry.isArrayType(methodReturnType)) {
            return;
        }
        Class<?> returnType = processMethodContext.getMethod().getReturnType();
        if (returnType.isArray()) {
            Class<?> componentType = returnType.getComponentType();
            FacetUtil.addFacet(new TypeOfFacetInferredFromArray(componentType, (FacetHolder)processMethodContext.getFacetHolder(), this.getSpecificationLoader()));
            return;
        }
        Method method = processMethodContext.getMethod();
        TypeOf annotation = Annotations.getAnnotation(method, TypeOf.class);
        if (annotation != null) {
            FacetUtil.addFacet(new TypeOfFacetAnnotationForCollection((Class<?>)annotation.value(), (FacetHolder)processMethodContext.getFacetHolder(), this.getSpecificationLoader()));
            return;
        }
        Type type = processMethodContext.getMethod().getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length == 0) {
            return;
        }
        Type actualTypeArgument = actualTypeArguments[0];
        if (actualTypeArgument instanceof Class) {
            Class actualType = (Class)actualTypeArgument;
            FacetUtil.addFacet(new TypeOfFacetInferredFromGenerics((Class<?>)actualType, (FacetHolder)processMethodContext.getFacetHolder(), this.getSpecificationLoader()));
            return;
        }
        if (actualTypeArgument instanceof TypeVariable) {
            return;
        }
    }

    @Override
    public void setCollectionTypeRegistry(CollectionTypeRegistry collectionTypeRegistry) {
        this.collectionTypeRegistry = collectionTypeRegistry;
    }
}

