/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.fallback;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.TypedHolder;
import org.apache.isis.core.progmodel.facets.fallback.ActionChoicesFacetNone;
import org.apache.isis.core.progmodel.facets.fallback.ActionDefaultsFacetNone;
import org.apache.isis.core.progmodel.facets.fallback.DescribedAsFacetNone;
import org.apache.isis.core.progmodel.facets.fallback.HelpFacetNone;
import org.apache.isis.core.progmodel.facets.fallback.MaxLengthFacetUnlimited;
import org.apache.isis.core.progmodel.facets.fallback.MultiLineFacetNone;
import org.apache.isis.core.progmodel.facets.fallback.NamedFacetNone;
import org.apache.isis.core.progmodel.facets.fallback.NotPersistableFacetNull;
import org.apache.isis.core.progmodel.facets.fallback.PagedFacetDefault;
import org.apache.isis.core.progmodel.facets.fallback.TitleFacetNone;

public class FallbackFacetFactory
extends FacetFactoryAbstract
implements IsisConfigurationAware {
    public static final int PAGE_SIZE_STANDALONE_DEFAULT = 25;
    public static final int PAGE_SIZE_PARENTED_DEFAULT = 12;
    private IsisConfiguration configuration;
    private static final Map<Class<?>, Integer> TYPICAL_LENGTHS_BY_CLASS = new HashMap<Class<?>, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.putTypicalLength(Byte.TYPE, Byte.class, 3);
            this.putTypicalLength(Short.TYPE, Short.class, 5);
            this.putTypicalLength(Integer.TYPE, Integer.class, 10);
            this.putTypicalLength(Long.TYPE, Long.class, 20);
            this.putTypicalLength(Float.TYPE, Float.class, 20);
            this.putTypicalLength(Double.TYPE, Double.class, 20);
            this.putTypicalLength(Character.TYPE, Character.class, 1);
            this.putTypicalLength(Boolean.TYPE, Boolean.class, 1);
        }

        private void putTypicalLength(Class<?> primitiveClass, Class<?> wrapperClass, int length) {
            this.put(primitiveClass, length);
            this.put(wrapperClass, length);
        }
    };

    public FallbackFacetFactory() {
        super(FeatureType.EVERYTHING);
    }

    public boolean recognizes(Method method) {
        return false;
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        Object facetHolder = processClassContaxt.getFacetHolder();
        DescribedAsFacetNone describedAsFacet = new DescribedAsFacetNone((FacetHolder)facetHolder);
        NotPersistableFacetNull notPersistableFacet = new NotPersistableFacetNull((FacetHolder)facetHolder);
        TitleFacetNone titleFacet = new TitleFacetNone((FacetHolder)facetHolder);
        PagedFacetDefault pagedFacet = new PagedFacetDefault((FacetHolder)facetHolder, this.getConfiguration().getInteger("isis.viewers.paged.standalone", 25));
        Facet[] facets = new Facet[]{describedAsFacet, notPersistableFacet, titleFacet, pagedFacet};
        FacetUtil.addFacets(facets);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        ArrayList<Facet> facets = new ArrayList<Facet>();
        FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
        facets.add(new NamedFacetNone(facetedMethod));
        facets.add(new DescribedAsFacetNone(facetedMethod));
        facets.add(new HelpFacetNone(facetedMethod));
        FeatureType featureType = facetedMethod.getFeatureType();
        if (featureType.isProperty()) {
            facets.add(new MaxLengthFacetUnlimited(facetedMethod));
            facets.add(new MultiLineFacetNone(true, (FacetHolder)facetedMethod));
        }
        if (featureType.isAction()) {
            facets.add(new ActionDefaultsFacetNone(facetedMethod));
            facets.add(new ActionChoicesFacetNone(facetedMethod));
        }
        if (featureType.isCollection()) {
            facets.add(new PagedFacetDefault(facetedMethod, this.getConfiguration().getInteger("isis.viewers.paged.parented", 12)));
        }
        FacetUtil.addFacets(facets);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        ArrayList<Facet> facets = new ArrayList<Facet>();
        TypedHolder typedHolder = (TypedHolder)processParameterContext.getFacetHolder();
        if (typedHolder.getFeatureType().isActionParameter()) {
            facets.add(new NamedFacetNone(typedHolder));
            facets.add(new DescribedAsFacetNone(typedHolder));
            facets.add(new HelpFacetNone(typedHolder));
            facets.add(new MultiLineFacetNone(false, (FacetHolder)typedHolder));
            facets.add(new MaxLengthFacetUnlimited(typedHolder));
        }
        FacetUtil.addFacets(facets);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }
}

