/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.describedas.annotation;

import java.util.Properties;
import org.apache.isis.applib.annotation.DescribedAs;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.progmodel.facets.members.describedas.annotation.DescribedAsFacetForMemberDerivedFromType;
import org.apache.isis.core.progmodel.facets.members.describedas.annotation.DescribedAsFacetOnMemberAnnotation;
import org.apache.isis.core.progmodel.facets.members.describedas.annotation.DescribedAsFacetOnMemberFromProperties;

public class DescribedAsOnMemberFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public DescribedAsOnMemberFacetFactory() {
        super(FeatureType.MEMBERS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        DescribedAsFacet facet = DescribedAsOnMemberFacetFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (facet == null) {
            facet = DescribedAsOnMemberFacetFactory.createFromAnnotationIfPossible(processMethodContext);
        }
        if (facet == null) {
            facet = this.createFromAnnotationOnReturnTypeIfPossible(processMethodContext);
        }
        FacetUtil.addFacet(facet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        DescribedAsFacet facet = DescribedAsOnMemberFacetFactory.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(facet);
    }

    private static DescribedAsFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("describedAs");
        return properties != null ? new DescribedAsFacetOnMemberFromProperties(properties, holder) : null;
    }

    private static DescribedAsFacet createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        DescribedAs annotation = Annotations.getAnnotation(processMethodContext.getMethod(), DescribedAs.class);
        return annotation == null ? null : new DescribedAsFacetOnMemberAnnotation(annotation.value(), (FacetHolder)processMethodContext.getFacetHolder());
    }

    private DescribedAsFacet createFromAnnotationOnReturnTypeIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> returnType = processMethodContext.getMethod().getReturnType();
        DescribedAsFacet returnTypeDescribedAsFacet = this.getDescribedAsFacet(returnType);
        return returnTypeDescribedAsFacet != null ? new DescribedAsFacetForMemberDerivedFromType(returnTypeDescribedAsFacet, (FacetHolder)processMethodContext.getFacetHolder()) : null;
    }

    private DescribedAsFacet getDescribedAsFacet(Class<?> type) {
        ObjectSpecification paramTypeSpec = this.getSpecificationLoader().loadSpecification(type);
        return paramTypeSpec.getFacet(DescribedAsFacet.class);
    }
}

