/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.describedas.staticmethod;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.describedas.staticmethod.DescribedAsFacetViaMethod;

public class DescribedAsFacetViaDescriptionMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"description"};

    public DescribedAsFacetViaDescriptionMethodFacetFactory() {
        super(FeatureType.MEMBERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        DescribedAsFacetViaDescriptionMethodFacetFactory.attachDescribedAsFacetIfDescriptionMethodIsFound(processMethodContext);
    }

    public static void attachDescribedAsFacetIfDescriptionMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseNameStripAccessorPrefixIfRequired(method.getName());
        Class<?> cls = processMethodContext.getCls();
        Method descriptionMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "description" + capitalizedName, String.class, new Class[0]);
        if (descriptionMethod == null) {
            return;
        }
        processMethodContext.removeMethod(descriptionMethod);
        String description = DescribedAsFacetViaDescriptionMethodFacetFactory.invokeDescriptionMethod(descriptionMethod);
        Object facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new DescribedAsFacetViaMethod(description, descriptionMethod, (FacetHolder)facetedMethod));
    }

    private static String invokeDescriptionMethod(Method descriptionMethod) {
        String description = null;
        try {
            description = (String)MethodExtensions.invokeStatic(descriptionMethod);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (description == null) {
            throw new MetaModelException("method " + descriptionMethod + "must return a string");
        }
        return description;
    }
}

