/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.disabled.annotation;

import java.util.Properties;
import org.apache.isis.applib.annotation.Disabled;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.progmodel.facets.members.disabled.annotation.DisabledFacetAnnotation;
import org.apache.isis.core.progmodel.facets.members.disabled.annotation.DisabledFacetFromProperties;

public class DisabledFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public DisabledFacetFactory() {
        super(FeatureType.MEMBERS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        DisabledFacet disabledFacet = DisabledFacetFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (disabledFacet == null) {
            disabledFacet = DisabledFacetFactory.createFromAnnotationIfPossible(processMethodContext);
        }
        FacetUtil.addFacet(disabledFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        DisabledFacet disabledFacet = DisabledFacetFactory.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(disabledFacet);
    }

    private static DisabledFacet createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Disabled annotation = Annotations.getAnnotation(processMethodContext.getMethod(), Disabled.class);
        return annotation != null ? new DisabledFacetAnnotation(annotation.when(), annotation.where(), annotation.reason(), (FacetHolder)processMethodContext.getFacetHolder()) : null;
    }

    private static DisabledFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("disabled");
        return properties != null ? new DisabledFacetFromProperties(properties, holder) : null;
    }
}

