/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.disabled.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.events.UsabilityEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.progmodel.facets.members.disabled.DisableForContextFacetAbstract;

public class DisableForContextFacetViaMethod
extends DisableForContextFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public DisableForContextFacetViaMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public String disables(UsabilityContext<? extends UsabilityEvent> ic) {
        ObjectAdapter target = ic.getTarget();
        if (target == null) {
            return null;
        }
        return (String)AdapterInvokeUtils.invoke(this.method, target, ic.getContributeeAsMap());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }
}

