/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.named.annotation;

import java.util.Properties;
import org.apache.isis.applib.annotation.Named;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.named.NamedFacet;
import org.apache.isis.core.progmodel.facets.members.named.annotation.NamedFacetOnMemberAnnotation;
import org.apache.isis.core.progmodel.facets.members.named.annotation.NamedFacetOnMemberFromProperties;

public class NamedOnMemberFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public NamedOnMemberFacetFactory() {
        super(FeatureType.MEMBERS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        NamedFacet namedFacet = NamedOnMemberFacetFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (namedFacet == null) {
            namedFacet = NamedOnMemberFacetFactory.createFromAnnotationIfPossible(processMethodContext);
        }
        FacetUtil.addFacet(namedFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        NamedFacet namedFacet = NamedOnMemberFacetFactory.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(namedFacet);
    }

    private static NamedFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("named");
        return properties != null ? new NamedFacetOnMemberFromProperties(properties, holder) : null;
    }

    private static NamedFacet createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Named annotation = Annotations.getAnnotation(processMethodContext.getMethod(), Named.class);
        return annotation != null ? new NamedFacetOnMemberAnnotation(annotation.value(), (FacetHolder)processMethodContext.getFacetHolder()) : null;
    }
}

