/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.disabled.method;

import java.lang.reflect.Method;
import org.apache.isis.applib.Identifier;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.object.disabled.DisabledObjectFacet;
import org.apache.isis.core.progmodel.facets.object.disabled.method.DisabledObjectFacetViaDisabledMethod;

public class DisabledObjectViaDisabledMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String DISABLED_PREFIX = "disabled";
    private static final String[] PREFIXES = new String[]{"disabled"};

    public DisabledObjectViaDisabledMethodFacetFactory() {
        super(FeatureType.EVERYTHING_BUT_PARAMETERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        Class[] params = new Class[]{Identifier.Type.class};
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, DISABLED_PREFIX, String.class, params);
        if (method == null) {
            return;
        }
        FacetUtil.addFacet(new DisabledObjectFacetViaDisabledMethod(method, (FacetHolder)facetHolder));
        processClassContext.removeMethod(method);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod member = (FacetedMethod)processMethodContext.getFacetHolder();
        Class<?> owningClass = processMethodContext.getCls();
        ObjectSpecification owningSpec = this.getSpecificationLoader().loadSpecification(owningClass);
        DisabledObjectFacet facet = owningSpec.getFacet(DisabledObjectFacet.class);
        if (facet != null) {
            facet.copyOnto(member);
        }
    }
}

