/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.encodeable;

import com.google.common.base.Strings;
import org.apache.isis.applib.annotation.Encodable;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.progmodel.facets.object.encodeable.EncodableFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.encodeable.EncoderDecoderUtil;

public class EncodableFacetAnnotation
extends EncodableFacetAbstract {
    private static String encoderDecoderName(Class<?> annotatedClass, IsisConfiguration configuration) {
        Encodable annotation = annotatedClass.getAnnotation(Encodable.class);
        String encoderDecoderName = annotation.encoderDecoderName();
        if (!Strings.isNullOrEmpty((String)encoderDecoderName)) {
            return encoderDecoderName;
        }
        return EncoderDecoderUtil.encoderDecoderNameFromConfiguration(annotatedClass, configuration);
    }

    private static Class<?> encoderDecoderClass(Class<?> annotatedClass) {
        Encodable annotation = annotatedClass.getAnnotation(Encodable.class);
        return annotation.encoderDecoderClass();
    }

    public EncodableFacetAnnotation(Class<?> annotatedClass, IsisConfiguration configuration, FacetHolder holder, AdapterManager adapterManager, ServicesInjector dependencyInjector) {
        this(EncodableFacetAnnotation.encoderDecoderName(annotatedClass, configuration), EncodableFacetAnnotation.encoderDecoderClass(annotatedClass), holder, adapterManager, dependencyInjector);
    }

    private EncodableFacetAnnotation(String candidateEncoderDecoderName, Class<?> candidateEncoderDecoderClass, FacetHolder holder, AdapterManager adapterManager, ServicesInjector dependencyInjector) {
        super(candidateEncoderDecoderName, candidateEncoderDecoderClass, holder, adapterManager, dependencyInjector);
    }
}

