/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.encodeable;

import org.apache.isis.applib.adapters.EncoderDecoder;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;

public class EncodableFacetUsingEncoderDecoder
extends FacetAbstract
implements EncodableFacet {
    private final EncoderDecoder<?> encoderDecoder;
    private final ServicesInjector dependencyInjector;
    private final AdapterManager adapterManager;
    public static String ENCODED_NULL = "NULL";

    public EncodableFacetUsingEncoderDecoder(EncoderDecoder<?> encoderDecoder, FacetHolder holder, AdapterManager adapterManager, ServicesInjector dependencyInjector) {
        super(EncodableFacet.class, holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.encoderDecoder = encoderDecoder;
        this.dependencyInjector = dependencyInjector;
        this.adapterManager = adapterManager;
    }

    @Override
    protected String toStringValues() {
        this.getDependencyInjector().injectServicesInto(this.encoderDecoder);
        return this.encoderDecoder.toString();
    }

    @Override
    public ObjectAdapter fromEncodedString(String encodedData) {
        Assert.assertNotNull(encodedData);
        if (ENCODED_NULL.equals(encodedData)) {
            return null;
        }
        this.getDependencyInjector().injectServicesInto(this.encoderDecoder);
        Object decodedObject = this.encoderDecoder.fromEncodedString(encodedData);
        return this.getAdapterManager().adapterFor(decodedObject);
    }

    @Override
    public String toEncodedString(ObjectAdapter adapter) {
        this.getDependencyInjector().injectServicesInto(this.encoderDecoder);
        return adapter == null ? ENCODED_NULL : EncodableFacetUsingEncoderDecoder.encode(this.encoderDecoder, adapter.getObject());
    }

    private static <T> String encode(EncoderDecoder<T> encoderDecoder, Object pojo) {
        Object pojoAsT = pojo;
        return encoderDecoder.toEncodedString(pojoAsT);
    }

    public ServicesInjector getDependencyInjector() {
        return this.dependencyInjector;
    }

    public AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

