/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.immutable.annotation;

import org.apache.isis.applib.annotation.Immutable;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.progmodel.facets.object.immutable.annotation.ImmutableFacetAnnotation;

public class ImmutableAnnotationFacetFactory
extends FacetFactoryAbstract {
    public ImmutableAnnotationFacetFactory() {
        super(FeatureType.EVERYTHING_BUT_PARAMETERS);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        Immutable annotation = Annotations.getAnnotation(processClassContaxt.getCls(), Immutable.class);
        FacetUtil.addFacet(this.create(annotation, (FacetHolder)processClassContaxt.getFacetHolder()));
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod member = (FacetedMethod)processMethodContext.getFacetHolder();
        Class<?> owningClass = processMethodContext.getCls();
        ObjectSpecification owningSpec = this.getSpecificationLoader().loadSpecification(owningClass);
        ImmutableFacet facet = owningSpec.getFacet(ImmutableFacet.class);
        if (facet != null) {
            facet.copyOnto(member);
        }
    }

    private ImmutableFacet create(Immutable annotation, FacetHolder holder) {
        return annotation == null ? null : new ImmutableFacetAnnotation(annotation.value(), holder);
    }
}

