/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.membergroups;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Properties;
import org.apache.isis.applib.annotation.MemberGroupLayout;
import org.apache.isis.core.commons.lang.StringFunctions;
import org.apache.isis.core.commons.lang.StringPredicates;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.progmodel.facets.object.membergroups.MemberGroupLayoutFacetAbstract;

public class MemberGroupLayoutFacetProperties
extends MemberGroupLayoutFacetAbstract {
    public MemberGroupLayoutFacetProperties(Properties properties, FacetHolder holder) {
        super(MemberGroupLayoutFacetProperties.asColumnSpans(properties), MemberGroupLayoutFacetProperties.asListWithDefaultGroup(MemberGroupLayoutFacetProperties.asGroupList(properties, "left")), MemberGroupLayoutFacetProperties.asList(MemberGroupLayoutFacetProperties.asGroupList(properties, "middle")), MemberGroupLayoutFacetProperties.asList(MemberGroupLayoutFacetProperties.asGroupList(properties, "right")), holder);
    }

    static MemberGroupLayout.ColumnSpans asColumnSpans(Properties properties) {
        String columnSpansStr = properties.getProperty("columnSpans");
        if (columnSpansStr == null) {
            return null;
        }
        try {
            return MemberGroupLayout.ColumnSpans.valueOf((String)columnSpansStr.trim());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    static String[] asGroupList(Properties properties, String key) {
        String property = properties.getProperty(key);
        if (property == null) {
            return new String[0];
        }
        Iterable split = Splitter.on((char)',').split((CharSequence)property);
        return (String[])Iterables.toArray((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)split, StringFunctions.TRIM), StringPredicates.NOT_EMPTY), String.class);
    }
}

