/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.parseable;

import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.progmodel.facets.object.parseable.ParseableFacetUsingParser;
import org.apache.isis.core.progmodel.facets.object.parseable.ParserUtil;

public abstract class ParseableFacetAbstract
extends FacetAbstract
implements ParseableFacet {
    private final Class<?> parserClass;
    private final ParseableFacetUsingParser parseableFacetUsingParser;

    public ParseableFacetAbstract(String candidateParserName, Class<?> candidateParserClass, FacetHolder holder, DeploymentCategory deploymentCategory, AuthenticationSessionProvider authenticationSessionProvider, ServicesInjector dependencyInjector, AdapterManager adapterManager) {
        super(ParseableFacet.class, holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.parserClass = ParserUtil.parserOrNull(candidateParserClass, candidateParserName);
        this.parseableFacetUsingParser = this.isValid() ? this.createParser(holder, deploymentCategory, authenticationSessionProvider, dependencyInjector, adapterManager) : null;
    }

    private ParseableFacetUsingParser createParser(FacetHolder holder, DeploymentCategory deploymentCategory, AuthenticationSessionProvider authenticationSessionProvider, ServicesInjector dependencyInjector, AdapterManager adapterManager) {
        Parser parser = (Parser)ClassExtensions.newInstance(this.parserClass, FacetHolder.class, holder);
        return new ParseableFacetUsingParser(parser, holder, deploymentCategory, authenticationSessionProvider, dependencyInjector, adapterManager);
    }

    public boolean isValid() {
        return this.parserClass != null;
    }

    public Class<?> getParserClass() {
        return this.parserClass;
    }

    @Override
    protected String toStringValues() {
        return this.parserClass.getName();
    }

    @Override
    public ObjectAdapter parseTextEntry(ObjectAdapter original, String entryText, Localization localization) {
        return this.parseableFacetUsingParser.parseTextEntry(original, entryText, localization);
    }

    @Override
    public String parseableTitle(ObjectAdapter existing) {
        return this.parseableFacetUsingParser.parseableTitle(existing);
    }
}

