/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.title;

import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;

public class TitleFacetUsingParser
extends FacetAbstract
implements TitleFacet {
    private final Parser parser;
    private final ServicesInjector dependencyInjector;

    public TitleFacetUsingParser(Parser parser, FacetHolder holder, ServicesInjector dependencyInjector) {
        super(TitleFacet.class, holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.parser = parser;
        this.dependencyInjector = dependencyInjector;
    }

    @Override
    protected String toStringValues() {
        this.getDependencyInjector().injectServicesInto(this.parser);
        return this.parser.toString();
    }

    @Override
    public String title(ObjectAdapter adapter, Localization localization) {
        if (adapter == null) {
            return null;
        }
        Object object = adapter.getObject();
        if (object == null) {
            return null;
        }
        this.getDependencyInjector().injectServicesInto(this.parser);
        return this.parser.displayTitleOf(object, localization);
    }

    @Override
    public String title(ObjectAdapter contextAdapter, ObjectAdapter targetAdapter, Localization localization) {
        return this.title(targetAdapter, localization);
    }

    public String title(ObjectAdapter adapter, String usingMask) {
        if (adapter == null) {
            return null;
        }
        Object object = adapter.getObject();
        if (object == null) {
            return null;
        }
        this.getDependencyInjector().injectServicesInto(this.parser);
        return this.parser.displayTitleOf(object, usingMask);
    }

    public ServicesInjector getDependencyInjector() {
        return this.dependencyInjector;
    }
}

