/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.title.annotation;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.object.title.annotation.TitleFacetViaTitleAnnotation;

public class TitleAnnotationFacetFactory
extends FacetFactoryAbstract
implements AdapterManagerAware,
MetaModelValidatorRefiner {
    private static final String TITLE_METHOD_NAME = "title";
    private AdapterManager adapterManager;

    public TitleAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        List<Method> methods = MethodFinderUtils.findMethodsWithAnnotation(cls, MethodScope.OBJECT, Title.class);
        Collections.sort(methods, new Comparator<Method>(){
            Comparator<String> comparator = new SequenceComparator();

            @Override
            public int compare(Method o1, Method o2) {
                Title a1 = o1.getAnnotation(Title.class);
                Title a2 = o2.getAnnotation(Title.class);
                return this.comparator.compare(a1.sequence(), a2.sequence());
            }
        });
        if (methods.isEmpty()) {
            return;
        }
        List titleComponents = Lists.transform(methods, TitleFacetViaTitleAnnotation.TitleComponent.FROM_METHOD);
        FacetUtil.addFacet(new TitleFacetViaTitleAnnotation(titleComponents, (FacetHolder)facetHolder, this.adapterManager));
    }

    @Override
    public void setAdapterManager(AdapterManager adapterMap) {
        this.adapterManager = adapterMap;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                Class<?> cls = objectSpec.getCorrespondingClass();
                Method titleMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, TitleAnnotationFacetFactory.TITLE_METHOD_NAME, String.class, null);
                if (titleMethod == null) {
                    return true;
                }
                Class<?> supClass = cls.getSuperclass();
                if (supClass == null) {
                    return true;
                }
                List<Method> methods = this.methodsWithTitleAnnotation(cls);
                List<Method> superClassMethods = this.methodsWithTitleAnnotation(supClass);
                if (methods.size() > superClassMethods.size()) {
                    validationFailures.add("Conflict for determining a strategy for retrieval of title for class %s that contains a method '%s' and an annotation '@%s'", objectSpec.getIdentifier().getClassName(), TitleAnnotationFacetFactory.TITLE_METHOD_NAME, Title.class.getName());
                }
                return true;
            }

            private List<Method> methodsWithTitleAnnotation(Class<?> cls) {
                return MethodFinderUtils.findMethodsWithAnnotation(cls, MethodScope.OBJECT, Title.class);
            }
        }));
    }

    static class SequenceComparator
    implements Comparator<String> {
        SequenceComparator() {
        }

        @Override
        public int compare(String sequence1, String sequence2) {
            List<String> components1 = SequenceComparator.componentsFor(sequence1);
            List<String> components2 = SequenceComparator.componentsFor(sequence2);
            int size1 = components1.size();
            int size2 = components2.size();
            if (size1 == 0 && size2 == 0) {
                return 0;
            }
            int n = 0;
            int length;
            while (size1 >= (length = n + 1) || size2 < length) {
                if (size2 < length && size1 >= length) {
                    return 1;
                }
                if (size1 < length && size2 < length) {
                    return 0;
                }
                int componentCompare = 0;
                try {
                    Integer c1 = Integer.valueOf(components1.get(n));
                    Integer c2 = Integer.valueOf(components2.get(n));
                    componentCompare = c1.compareTo(c2);
                }
                catch (NumberFormatException nfe) {
                    componentCompare = components1.get(n).compareTo(components2.get(n));
                }
                if (componentCompare != 0) {
                    return componentCompare;
                }
                ++n;
            }
            return -1;
        }

        private static List<String> componentsFor(String sequence) {
            return Lists.newArrayList((Iterable)Splitter.on((char)'.').split((CharSequence)sequence));
        }
    }
}

