/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.choices.method;

import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.param.choices.method.ActionChoicesFacetViaMethod;

public class ActionChoicesFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterManagerAware {
    private static final String[] PREFIXES = new String[]{"choices"};
    private AdapterManager adapterManager;

    public ActionChoicesFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachActionChoicesFacetIfParameterChoicesMethodIsFound(processMethodContext);
    }

    private void attachActionChoicesFacetIfParameterChoicesMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        Class<?>[] actionParamTypes = actionMethod.getParameterTypes();
        if (actionParamTypes.length <= 0) {
            return;
        }
        Method choicesMethod = null;
        if (choicesMethod == null) {
            choicesMethod = this.findChoicesMethodReturning(processMethodContext, Object[][].class);
        }
        if (choicesMethod == null) {
            choicesMethod = this.findChoicesMethodReturning(processMethodContext, Object[].class);
        }
        if (choicesMethod == null) {
            choicesMethod = this.findChoicesMethodReturning(processMethodContext, Collection.class);
        }
        if (choicesMethod == null) {
            return;
        }
        processMethodContext.removeMethod(choicesMethod);
        Class<?> returnType = actionMethod.getReturnType();
        Object action = processMethodContext.getFacetHolder();
        ActionChoicesFacetViaMethod facet = new ActionChoicesFacetViaMethod(choicesMethod, returnType, (FacetHolder)action, this.getSpecificationLoader(), this.getAdapterManager());
        FacetUtil.addFacet(facet);
    }

    protected Method findChoicesMethodReturning(FacetFactory.ProcessMethodContext processMethodContext, Class<?> returnType2) {
        Class<?> cls = processMethodContext.getCls();
        Method actionMethod = processMethodContext.getMethod();
        MethodScope methodScope = MethodScope.scopeFor(actionMethod);
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        String name = "choices" + capitalizedName;
        Method choicesMethod = MethodFinderUtils.findMethod(cls, methodScope, name, returnType2, new Class[0]);
        return choicesMethod;
    }

    @Override
    public void setAdapterManager(AdapterManager adapterMap) {
        this.adapterManager = adapterMap;
    }

    protected AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

