/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.describedas.staticmethod;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.describedas.staticmethod.DescribedAsFacetViaMethod;

public class ActionParameterDescriptionsMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"description"};

    public ActionParameterDescriptionsMethodFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
        List<FacetedMethodParameter> holderList = facetedMethod.getParameters();
        ActionParameterDescriptionsMethodFacetFactory.attachDescribedAsFacetForParametersIfParameterDescriptionsMethodIsFound(processMethodContext, holderList);
    }

    private static void attachDescribedAsFacetForParametersIfParameterDescriptionsMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext, List<FacetedMethodParameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        Class<?> cls = processMethodContext.getCls();
        Method descriptionMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "description" + capitalizedName, String[].class, new Class[0]);
        if (descriptionMethod == null) {
            return;
        }
        processMethodContext.removeMethod(descriptionMethod);
        String[] descriptions = ActionParameterDescriptionsMethodFacetFactory.invokeDescriptionsMethod(descriptionMethod, parameters.size());
        for (int i = 0; i < descriptions.length; ++i) {
            FacetUtil.addFacet(new DescribedAsFacetViaMethod(descriptions[i], descriptionMethod, parameters.get(i)));
        }
    }

    private static String[] invokeDescriptionsMethod(Method descriptionMethod, int numElementsRequired) {
        String[] descriptions = null;
        try {
            descriptions = (String[])MethodExtensions.invokeStatic(descriptionMethod, new Object[0]);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (descriptions == null || descriptions.length != numElementsRequired) {
            throw new MetaModelException(descriptionMethod + " must return an String[] array of same size as number of parameters of action");
        }
        return descriptions;
    }
}

