/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.mandatory.annotation;

import java.lang.annotation.Annotation;
import org.apache.isis.applib.annotation.Optional;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.param.mandatory.annotation.MandatoryFacetInvertedByOptionalForParameter;

public class OptionalAnnotationForParameterFacetFactory
extends FacetFactoryAbstract {
    public OptionalAnnotationForParameterFacetFactory() {
        super(FeatureType.PARAMETERS_ONLY);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Annotation[] parameterAnnotations;
        Class<?>[] parameterTypes = processParameterContext.getMethod().getParameterTypes();
        if (processParameterContext.getParamNum() >= parameterTypes.length) {
            return;
        }
        if (parameterTypes[processParameterContext.getParamNum()].isPrimitive()) {
            return;
        }
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(processParameterContext.getMethod())[processParameterContext.getParamNum()]) {
            if (!(parameterAnnotation instanceof Optional)) continue;
            FacetUtil.addFacet(new MandatoryFacetInvertedByOptionalForParameter((FacetHolder)processParameterContext.getFacetHolder()));
            return;
        }
    }
}

