/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.validate.perspec;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.apache.isis.applib.annotation.MustSatisfy;
import org.apache.isis.applib.spec.Specification;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.param.validate.perspec.MustSatisfySpecificationOnParameterFacet;

public class MustSatisfySpecificationOnParameterFacetFactory
extends FacetFactoryAbstract {
    public MustSatisfySpecificationOnParameterFacetFactory() {
        super(FeatureType.PARAMETERS_ONLY);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Annotation[] parameterAnnotations;
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(processParameterContext.getMethod())[processParameterContext.getParamNum()]) {
            if (!(parameterAnnotation instanceof MustSatisfy)) continue;
            MustSatisfy annotation = (MustSatisfy)parameterAnnotation;
            FacetUtil.addFacet(this.create(annotation, (FacetHolder)processParameterContext.getFacetHolder()));
            return;
        }
    }

    private Facet create(MustSatisfy annotation, FacetHolder holder) {
        if (annotation == null) {
            return null;
        }
        Class[] values = annotation.value();
        ArrayList<Specification> specifications = new ArrayList<Specification>();
        for (Class value : values) {
            Specification specification = MustSatisfySpecificationOnParameterFacetFactory.newSpecificationElseNull(value);
            if (specification == null) continue;
            specifications.add(specification);
        }
        return specifications.size() > 0 ? new MustSatisfySpecificationOnParameterFacet(specifications, holder) : null;
    }

    private static Specification newSpecificationElseNull(Class<?> value) {
        if (!Specification.class.isAssignableFrom(value)) {
            return null;
        }
        try {
            return (Specification)value.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

