/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.validate.regexannot;

import java.lang.annotation.Annotation;
import org.apache.isis.applib.annotation.RegEx;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.progmodel.facets.object.regex.RegExFacet;
import org.apache.isis.core.progmodel.facets.object.regex.TitleFacetFormattedByRegex;
import org.apache.isis.core.progmodel.facets.param.validate.regexannot.RegExFacetAnnotationForParameter;

public class RegExFacetAnnotationForParameterFacetFactory
extends FacetFactoryAbstract {
    public RegExFacetAnnotationForParameterFacetFactory() {
        super(FeatureType.PARAMETERS_ONLY);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Annotation[] parameterAnnotations;
        Class<?>[] parameterTypes = processParameterContext.getMethod().getParameterTypes();
        if (processParameterContext.getParamNum() >= parameterTypes.length) {
            return;
        }
        if (!Annotations.isString(parameterTypes[processParameterContext.getParamNum()])) {
            return;
        }
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(processParameterContext.getMethod())[processParameterContext.getParamNum()]) {
            if (!(parameterAnnotation instanceof RegEx)) continue;
            RegEx annotation = (RegEx)parameterAnnotation;
            this.addRegexFacetAndCorrespondingTitleFacet((FacetHolder)processParameterContext.getFacetHolder(), annotation);
            return;
        }
    }

    private void addRegexFacetAndCorrespondingTitleFacet(FacetHolder holder, RegEx annotation) {
        RegExFacet regexFacet = this.createRegexFacet(annotation, holder);
        if (regexFacet == null) {
            return;
        }
        FacetUtil.addFacet(regexFacet);
        TitleFacet titleFacet = this.createTitleFacet(regexFacet);
        FacetUtil.addFacet(titleFacet);
    }

    private RegExFacet createRegexFacet(RegEx annotation, FacetHolder holder) {
        if (annotation == null) {
            return null;
        }
        String validationExpression = annotation.validation();
        boolean caseSensitive = annotation.caseSensitive();
        String formatExpression = annotation.format();
        return new RegExFacetAnnotationForParameter(validationExpression, formatExpression, caseSensitive, holder);
    }

    private TitleFacet createTitleFacet(RegExFacet regexFacet) {
        return new TitleFacetFormattedByRegex(regexFacet);
    }
}

