/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.defaults.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.exceptions.UnknownTypeException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.progmodel.facets.properties.defaults.PropertyDefaultFacetAbstract;

public class PropertyDefaultFacetViaMethod
extends PropertyDefaultFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final SpecificationLoader specificationLookup;
    private final AdapterManager adapterManager;

    public PropertyDefaultFacetViaMethod(Method method, FacetHolder holder, SpecificationLoader specificationLookup, AdapterManager adapterManager) {
        super(holder);
        this.method = method;
        this.specificationLookup = specificationLookup;
        this.adapterManager = adapterManager;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public ObjectAdapter getDefault(ObjectAdapter owningAdapter) {
        Object result = AdapterInvokeUtils.invoke(this.method, owningAdapter);
        if (result == null) {
            return null;
        }
        return this.createAdapter(this.method.getReturnType(), result);
    }

    private ObjectAdapter createAdapter(Class<?> type, Object object) {
        ObjectSpecification specification = this.getSpecificationLookup().loadSpecification(type);
        if (specification.isNotCollection()) {
            return this.getAdapterManager().adapterFor(object);
        }
        throw new UnknownTypeException("not an object, is this a collection?");
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    private SpecificationLoader getSpecificationLookup() {
        return this.specificationLookup;
    }

    protected AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

