/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.event;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import org.apache.isis.applib.annotation.PostsPropertyChangedEvent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ServicesProvider;
import org.apache.isis.core.metamodel.adapter.ServicesProviderAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.collections.sortedby.SortedByFacet;
import org.apache.isis.core.metamodel.facets.properties.event.PostsPropertyChangedEventFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertyClearFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.core.progmodel.facets.properties.event.PostsPropertyChangedEventFacetAnnotation;

public class PostsPropertyChangedEventAnnotationFacetFactory
extends FacetFactoryAbstract
implements ServicesProviderAware,
MetaModelValidatorRefiner {
    private ServicesProvider servicesProvider;

    public PostsPropertyChangedEventAnnotationFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        FacetUtil.addFacet(this.create(method, (FacetHolder)processMethodContext.getFacetHolder()));
    }

    private PostsPropertyChangedEventFacet create(Method method, FacetHolder holder) {
        PostsPropertyChangedEvent annotation = Annotations.getAnnotation(method, PostsPropertyChangedEvent.class);
        if (annotation == null) {
            return null;
        }
        PropertyOrCollectionAccessorFacet getterFacet = holder.getFacet(PropertyOrCollectionAccessorFacet.class);
        if (getterFacet == null) {
            return null;
        }
        PropertyClearFacet clearFacet = holder.getFacet(PropertyClearFacet.class);
        PropertySetterFacet setterFacet = holder.getFacet(PropertySetterFacet.class);
        if (clearFacet == null && setterFacet == null) {
            return null;
        }
        if (setterFacet != null) {
            holder.removeFacet(setterFacet);
        }
        if (clearFacet != null) {
            holder.removeFacet(clearFacet);
        }
        Class changedEventType = annotation.value();
        return new PostsPropertyChangedEventFacetAnnotation(changedEventType, getterFacet, setterFacet, clearFacet, this.servicesProvider, holder);
    }

    @Override
    public void setServicesProvider(ServicesProvider servicesProvider) {
        this.servicesProvider = servicesProvider;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(this.newValidatorVisitor()));
    }

    protected MetaModelValidatorVisiting.Visitor newValidatorVisitor() {
        return new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                List<OneToManyAssociation> objectCollections = objectSpec.getCollections(Contributed.EXCLUDED);
                for (OneToManyAssociation objectCollection : objectCollections) {
                    Class cls;
                    SortedByFacet facet = objectCollection.getFacet(SortedByFacet.class);
                    if (facet == null || Comparator.class.isAssignableFrom(cls = (Class)facet.value())) continue;
                    validationFailures.add("%s#%s is annotated with @SortedBy, but the class specified '%s' is not a Comparator", objectSpec.getIdentifier().getClassName(), objectCollection.getId(), ((Class)facet.value()).getName());
                }
                return true;
            }
        };
    }
}

