/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.event;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.isis.applib.FatalException;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.applib.services.eventbus.PropertyChangedEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ServicesProvider;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.properties.event.PostsPropertyChangedEventFacet;
import org.apache.isis.core.metamodel.facets.properties.event.PostsPropertyChangedEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertyClearFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertySetterFacet;

public class PostsPropertyChangedEventFacetAnnotation
extends PostsPropertyChangedEventFacetAbstract {
    private final PropertyOrCollectionAccessorFacet getterFacet;
    private final PropertySetterFacet setterFacet;
    private final PropertyClearFacet clearFacet;
    private final ServicesProvider servicesProvider;
    private EventBusService eventBusService;
    private boolean searchedForEventBusService = false;

    public PostsPropertyChangedEventFacetAnnotation(Class<? extends PropertyChangedEvent<?, ?>> changedEventType, PropertyOrCollectionAccessorFacet getterFacet, PropertySetterFacet setterFacet, PropertyClearFacet clearFacet, ServicesProvider servicesProvider, FacetHolder holder) {
        super(changedEventType, holder);
        this.getterFacet = getterFacet;
        this.setterFacet = setterFacet;
        this.clearFacet = clearFacet;
        this.servicesProvider = servicesProvider;
    }

    @Override
    public void setProperty(ObjectAdapter inObject, ObjectAdapter value) {
        if (this.setterFacet == null) {
            return;
        }
        this.eventBusService = this.getEventBusService();
        if (this.eventBusService == null) {
            this.setterFacet.setProperty(inObject, value);
            return;
        }
        Object oldValue = this.getterFacet.getProperty(inObject);
        this.setterFacet.setProperty(inObject, value);
        Object newValue = this.getterFacet.getProperty(inObject);
        this.postEventIfChanged(inObject, oldValue, newValue);
    }

    @Override
    public void clearProperty(ObjectAdapter inObject) {
        if (this.clearFacet == null) {
            return;
        }
        this.eventBusService = this.getEventBusService();
        if (this.eventBusService == null) {
            this.clearFacet.clearProperty(inObject);
            return;
        }
        Object oldValue = this.getterFacet.getProperty(inObject);
        this.clearFacet.clearProperty(inObject);
        Object newValue = this.getterFacet.getProperty(inObject);
        this.postEventIfChanged(inObject, oldValue, newValue);
    }

    private void postEventIfChanged(ObjectAdapter inObject, Object oldValue, Object newValue) {
        if (Objects.equal((Object)oldValue, (Object)newValue)) {
            return;
        }
        Object source = inObject.getObject();
        try {
            Class type = (Class)this.value();
            PropertyChangedEvent<Object, Object> event = PostsPropertyChangedEventFacetAnnotation.newEvent(type, oldValue, newValue, source);
            this.eventBusService.post(event);
        }
        catch (Exception e) {
            throw new FatalException((Throwable)e);
        }
    }

    static <S, T> PropertyChangedEvent<S, T> newEvent(Class<? extends PropertyChangedEvent<S, T>> type, T oldValue, T newValue, S source) throws InstantiationException, IllegalAccessException, NoSuchFieldException {
        PropertyChangedEvent<S, T> event = type.newInstance();
        PostsPropertyChangedEventFacetAnnotation.setField("source", event, source);
        PostsPropertyChangedEventFacetAnnotation.setField("oldValue", event, oldValue);
        PostsPropertyChangedEventFacetAnnotation.setField("newValue", event, newValue);
        return event;
    }

    private static void setField(String name, PropertyChangedEvent<?, ?> event, Object sourceValue) throws NoSuchFieldException, IllegalAccessException {
        Field sourceField = PropertyChangedEvent.class.getDeclaredField(name);
        sourceField.setAccessible(true);
        sourceField.set(event, sourceValue);
    }

    private EventBusService getEventBusService() {
        if (!this.searchedForEventBusService) {
            List<ObjectAdapter> serviceAdapters = this.servicesProvider.getServices();
            for (ObjectAdapter serviceAdapter : serviceAdapters) {
                Object service = serviceAdapter.getObject();
                if (!(service instanceof EventBusService)) continue;
                this.eventBusService = (EventBusService)service;
                break;
            }
        }
        this.searchedForEventBusService = true;
        return this.eventBusService;
    }

    @Override
    public Class<? extends Facet>[] facetTypes() {
        return Lists.newArrayList((Object[])new Class[]{PostsPropertyChangedEventFacet.class, PropertySetterFacet.class, PropertyClearFacet.class}).toArray(new Class[0]);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> facet) {
        return (T)this;
    }
}

