/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.validate.maskannot;

import java.lang.annotation.Annotation;
import org.apache.isis.applib.annotation.Mask;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.progmodel.facets.object.mask.MaskFacet;
import org.apache.isis.core.progmodel.facets.object.mask.TitleFacetBasedOnMask;
import org.apache.isis.core.progmodel.facets.properties.validate.maskannot.MaskFacetAnnotationForProperty;

public class MaskAnnotationForPropertyFacetFactory
extends FacetFactoryAbstract {
    public MaskAnnotationForPropertyFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        Mask annotation = Annotations.getAnnotation(processClassContaxt.getCls(), Mask.class);
        FacetUtil.addFacet(this.createMaskFacet(annotation, (FacetHolder)processClassContaxt.getFacetHolder()));
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        if (processMethodContext.getMethod().getReturnType() == Void.TYPE) {
            return;
        }
        Mask annotation = Annotations.getAnnotation(processMethodContext.getMethod(), Mask.class);
        this.addMaskFacetAndCorrespondingTitleFacet((FacetHolder)processMethodContext.getFacetHolder(), annotation, processMethodContext.getMethod().getReturnType());
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Class<?>[] parameterTypes = processParameterContext.getMethod().getParameterTypes();
        if (processParameterContext.getParamNum() >= parameterTypes.length) {
            return;
        }
        Annotation[] parameterAnnotations = Annotations.getParameterAnnotations(processParameterContext.getMethod())[processParameterContext.getParamNum()];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            if (!(parameterAnnotations[i] instanceof Mask)) continue;
            Mask annotation = (Mask)parameterAnnotations[i];
            this.addMaskFacetAndCorrespondingTitleFacet((FacetHolder)processParameterContext.getFacetHolder(), annotation, parameterTypes[i]);
            return;
        }
    }

    private MaskFacet createMaskFacet(Mask annotation, FacetHolder holder) {
        return annotation != null ? new MaskFacetAnnotationForProperty(annotation.value(), null, holder) : null;
    }

    private boolean addMaskFacetAndCorrespondingTitleFacet(FacetHolder holder, Mask annotation, Class<?> cls) {
        MaskFacet maskFacet = this.createMaskFacet(annotation, holder);
        if (maskFacet == null) {
            return false;
        }
        FacetUtil.addFacet(maskFacet);
        ObjectSpecification type = this.getSpecificationLoader().loadSpecification(cls);
        TitleFacet underlyingTitleFacet = type.getFacet(TitleFacet.class);
        if (underlyingTitleFacet != null) {
            TitleFacetBasedOnMask titleFacet = new TitleFacetBasedOnMask(maskFacet, underlyingTitleFacet);
            FacetUtil.addFacet(titleFacet);
        }
        return true;
    }
}

