/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.validate.perspec;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.isis.applib.annotation.MustSatisfy;
import org.apache.isis.applib.spec.Specification;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.properties.validate.perspec.MustSatisfySpecificationOnPropertyFacet;

public class MustSatisfySpecificationOnPropertyFacetFactory
extends FacetFactoryAbstract {
    public MustSatisfySpecificationOnPropertyFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetUtil.addFacet(this.create(processMethodContext.getMethod(), (FacetHolder)processMethodContext.getFacetHolder()));
    }

    private Facet create(Method method, FacetHolder holder) {
        return this.create(Annotations.getAnnotation(method, MustSatisfy.class), holder);
    }

    private Facet create(MustSatisfy annotation, FacetHolder holder) {
        if (annotation == null) {
            return null;
        }
        Class[] values = annotation.value();
        ArrayList<Specification> specifications = new ArrayList<Specification>();
        for (Class value : values) {
            Specification specification = MustSatisfySpecificationOnPropertyFacetFactory.newSpecificationElseNull(value);
            if (specification == null) continue;
            specifications.add(specification);
        }
        return specifications.size() > 0 ? new MustSatisfySpecificationOnPropertyFacet(specifications, holder) : null;
    }

    private static Specification newSpecificationElseNull(Class<?> value) {
        if (!Specification.class.isAssignableFrom(value)) {
            return null;
        }
        try {
            return (Specification)value.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

