/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value.datejodalocal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.adapters.EncodingException;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.datejodalocal.JodaLocalDateUtil;
import org.apache.isis.core.progmodel.facets.value.datejodalocal.JodaLocalDateValueFacet;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class JodaLocalDateValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<LocalDate>
implements JodaLocalDateValueFacet {
    public static final String CFG_FORMAT_KEY = "isis.value.format.date";
    private static Map<String, DateTimeFormatter> NAMED_TITLE_FORMATTERS = Maps.newHashMap();
    private static final ThreadLocal<String> OVERRIDE_TITLE_PATTERN;
    private static final List<DateTimeFormatter> PARSE_FORMATTERS;
    private static final LocalDate DEFAULT_VALUE;
    private final DateTimeFormatter encodingFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd");
    private DateTimeFormatter titleStringFormatter;
    private String titleStringFormatNameOrPattern;

    @Deprecated
    public static void setFormat(String propertyType, String pattern) {
        JodaLocalDateValueSemanticsProvider.setTitlePatternOverride(pattern);
    }

    public static void setTitlePatternOverride(String pattern) {
        OVERRIDE_TITLE_PATTERN.set(pattern);
    }

    public static Class<? extends Facet> type() {
        return JodaLocalDateValueFacet.class;
    }

    public JodaLocalDateValueSemanticsProvider() {
        this((FacetHolder)null, (IsisConfiguration)null, (ValueSemanticsProviderContext)null);
    }

    public JodaLocalDateValueSemanticsProvider(FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(JodaLocalDateValueSemanticsProvider.type(), holder, LocalDate.class, 12, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, configuration, context);
        String configuredNameOrPattern = this.getConfiguration().getString(CFG_FORMAT_KEY, "medium").toLowerCase().trim();
        this.updateTitleStringFormatter(configuredNameOrPattern);
    }

    private void updateTitleStringFormatter(String titleStringFormatNameOrPattern) {
        this.titleStringFormatter = NAMED_TITLE_FORMATTERS.get(titleStringFormatNameOrPattern);
        if (this.titleStringFormatter == null) {
            this.titleStringFormatter = DateTimeFormat.forPattern((String)titleStringFormatNameOrPattern);
        }
        this.titleStringFormatNameOrPattern = titleStringFormatNameOrPattern;
    }

    @Override
    protected LocalDate doParse(Object context, String entry, Localization localization) {
        this.updateTitleStringFormatterIfOverridden();
        LocalDate contextDate = (LocalDate)context;
        String dateString = entry.trim().toUpperCase();
        if (dateString.startsWith("+") && contextDate != null) {
            return JodaLocalDateUtil.relativeDate(contextDate, dateString, true);
        }
        if (dateString.startsWith("-") && contextDate != null) {
            return JodaLocalDateUtil.relativeDate(contextDate, dateString, false);
        }
        return this.parseDate(dateString, contextDate, localization);
    }

    private void updateTitleStringFormatterIfOverridden() {
        String overridePattern = OVERRIDE_TITLE_PATTERN.get();
        if (overridePattern == null || this.titleStringFormatNameOrPattern.equals(overridePattern)) {
            return;
        }
        this.updateTitleStringFormatter(overridePattern);
    }

    private LocalDate parseDate(String dateStr, Object original, Localization localization) {
        return JodaLocalDateUtil.parseDate(dateStr, localization, PARSE_FORMATTERS);
    }

    @Override
    public String titleString(Object value, Localization localization) {
        if (value == null) {
            return null;
        }
        LocalDate date = (LocalDate)value;
        DateTimeFormatter f = this.titleStringFormatter;
        if (localization != null) {
            f = this.titleStringFormatter.withLocale(localization.getLocale());
        }
        return JodaLocalDateUtil.titleString(f, date);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        LocalDate date = (LocalDate)value;
        return JodaLocalDateUtil.titleString(DateTimeFormat.forPattern((String)usingMask), date);
    }

    @Override
    protected String doEncode(Object object) {
        LocalDate date = (LocalDate)object;
        return this.encode(date);
    }

    private synchronized String encode(LocalDate date) {
        return this.encodingFormatter.print((ReadablePartial)date);
    }

    @Override
    protected LocalDate doRestore(String data) {
        try {
            return this.parse(data);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException((Throwable)e);
        }
    }

    private synchronized LocalDate parse(String data) {
        return this.encodingFormatter.parseLocalDate(data);
    }

    @Override
    public final LocalDate dateValue(ObjectAdapter object) {
        return (LocalDate)(object == null ? null : object.getObject());
    }

    @Override
    public final ObjectAdapter createValue(LocalDate date) {
        return this.getAdapterManager().adapterFor(date);
    }

    @Override
    public String toString() {
        return "JodaLocalDateValueSemanticsProvider: " + this.titleStringFormatter;
    }

    static {
        NAMED_TITLE_FORMATTERS.put("iso_encoding", DateTimeFormat.forPattern((String)"yyyyMMdd"));
        NAMED_TITLE_FORMATTERS.put("iso", DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
        NAMED_TITLE_FORMATTERS.put("long", DateTimeFormat.forStyle((String)"L-"));
        NAMED_TITLE_FORMATTERS.put("medium", DateTimeFormat.forStyle((String)"M-"));
        NAMED_TITLE_FORMATTERS.put("short", DateTimeFormat.forStyle((String)"S-"));
        OVERRIDE_TITLE_PATTERN = new ThreadLocal<String>(){

            @Override
            protected String initialValue() {
                return null;
            }
        };
        PARSE_FORMATTERS = Lists.newArrayList();
        PARSE_FORMATTERS.add(DateTimeFormat.forStyle((String)"L-"));
        PARSE_FORMATTERS.add(DateTimeFormat.forStyle((String)"M-"));
        PARSE_FORMATTERS.add(DateTimeFormat.forStyle((String)"S-"));
        PARSE_FORMATTERS.add(DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
        PARSE_FORMATTERS.add(DateTimeFormat.forPattern((String)"yyyyMMdd"));
        DEFAULT_VALUE = null;
    }
}

