/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.snapshot;

import com.google.common.collect.Maps;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.isis.applib.ViewModel;
import org.apache.isis.applib.services.xmlsnapshot.XmlSnapshotService;
import org.apache.isis.applib.snapshot.SnapshottableWithInclusions;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.ObjectSpecificationException;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.snapshot.IsisSchema;
import org.apache.isis.core.runtime.snapshot.Place;
import org.apache.isis.core.runtime.snapshot.XmlSchema;
import org.apache.isis.core.runtime.snapshot.XsMetaModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSnapshot
implements XmlSnapshotService.Snapshot {
    private static final Logger LOG = LoggerFactory.getLogger(XmlSnapshot.class);
    private final IsisSchema isisMetaModel;
    private final Place rootPlace;
    private final XmlSchema schema;
    private String schemaLocationFileName;
    private boolean topLevelElementWritten = false;
    private final Document xmlDocument;
    private Element xmlElement;
    private final Document xsdDocument;
    private final Element xsdElement;
    private final XsMetaModel xsMeta;
    private final OidMarshaller oidMarshaller;
    private final Map<ObjectAdapter, String> viewModelFakeOids = Maps.newHashMap();

    public XmlSnapshot(ObjectAdapter rootAdapter, OidMarshaller oidMarshaller) {
        this(rootAdapter, new XmlSchema(), oidMarshaller);
    }

    public XmlSnapshot(ObjectAdapter rootAdapter, XmlSchema schema, OidMarshaller oidMarshaller) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(".ctor(" + this.log("rootObj", rootAdapter) + this.andlog("schema", schema) + this.andlog("addOids", "true") + ")");
        }
        this.isisMetaModel = new IsisSchema();
        this.xsMeta = new XsMetaModel();
        this.schema = schema;
        this.oidMarshaller = oidMarshaller;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.xmlDocument = db.newDocument();
            this.xsdDocument = db.newDocument();
            this.xsdElement = this.xsMeta.createXsSchemaElement(this.xsdDocument);
            this.rootPlace = this.appendXml(rootAdapter);
        }
        catch (ParserConfigurationException e) {
            LOG.error("unable to build snapshot", (Throwable)e);
            throw new IsisException(e);
        }
        for (String path : this.getPathsFor(rootAdapter.getObject())) {
            this.include(path);
        }
    }

    private List<String> getPathsFor(Object object) {
        if (!(object instanceof SnapshottableWithInclusions)) {
            return Collections.emptyList();
        }
        List paths = ((SnapshottableWithInclusions)object).snapshotInclusions();
        if (paths == null) {
            return Collections.emptyList();
        }
        return paths;
    }

    private String andlog(String label, ObjectAdapter object) {
        return ", " + this.log(label, object);
    }

    private String andlog(String label, Object object) {
        return ", " + this.log(label, object);
    }

    private Place appendXml(ObjectAdapter object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendXml(" + this.log("obj", object) + "')");
        }
        String fullyQualifiedClassName = object.getSpecification().getFullIdentifier();
        this.schema.setUri(fullyQualifiedClassName);
        Place place = this.objectToElement(object);
        Element element = place.getXmlElement();
        Element xsElementElement = place.getXsdElement();
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendXml(NO): add as element to XML doc");
        }
        this.getXmlDocument().appendChild(element);
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendXml(NO): add as xs:element to xs:schema of the XSD document");
        }
        this.getXsdElement().appendChild(xsElementElement);
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendXml(NO): set target name in XSD, derived from FQCN of obj");
        }
        this.schema.setTargetNamespace(this.getXsdDocument(), fullyQualifiedClassName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendXml(NO): set schema location file name to XSD, derived from FQCN of obj");
        }
        String schemaLocationFileName = fullyQualifiedClassName + ".xsd";
        this.schema.assignSchema(this.getXmlDocument(), fullyQualifiedClassName, schemaLocationFileName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendXml(NO): copy into snapshot obj");
        }
        this.setXmlElement(element);
        this.setSchemaLocationFileName(schemaLocationFileName);
        return place;
    }

    private Element appendXml(Place parentPlace, ObjectAdapter childObject) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendXml(" + this.log("parentPlace", parentPlace) + this.andlog("childObj", childObject) + ")");
        }
        Element parentElement = parentPlace.getXmlElement();
        Element parentXsElement = parentPlace.getXsdElement();
        if (parentElement.getOwnerDocument() != this.getXmlDocument()) {
            throw new IllegalArgumentException("parent XML Element must have snapshot's XML document as its owner");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendXml(Pl, NO): invoking objectToElement() for " + this.log("childObj", childObject));
        }
        Place childPlace = this.objectToElement(childObject);
        Element childElement = childPlace.getXmlElement();
        Element childXsElement = childPlace.getXsdElement();
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendXml(Pl, NO): invoking mergeTree of parent with child");
        }
        childElement = this.mergeTree(parentElement, childElement);
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendXml(Pl, NO): adding XS Element to schema if required");
        }
        this.schema.addXsElementIfNotPresent(parentXsElement, childXsElement);
        return childElement;
    }

    private boolean appendXmlThenIncludeRemaining(Place parentPlace, ObjectAdapter referencedObject, Vector fieldNames, String annotation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendXmlThenIncludeRemaining(: " + this.log("parentPlace", parentPlace) + this.andlog("referencedObj", referencedObject) + this.andlog("fieldNames", fieldNames) + this.andlog("annotation", annotation) + ")");
            LOG.debug("appendXmlThenIncludeRemaining(..): invoking appendXml(parentPlace, referencedObject)");
        }
        Element referencedElement = this.appendXml(parentPlace, referencedObject);
        Place referencedPlace = new Place(referencedObject, referencedElement);
        boolean includedField = this.includeField(referencedPlace, fieldNames, annotation);
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendXmlThenIncludeRemaining(..): invoked includeField(referencedPlace, fieldNames)" + this.andlog("returned", "" + includedField));
        }
        return includedField;
    }

    private Vector elementsUnder(Element parentElement, String localName) {
        Vector<Element> v = new Vector<Element>();
        NodeList existingNodes = parentElement.getChildNodes();
        for (int i = 0; i < existingNodes.getLength(); ++i) {
            Node node = existingNodes.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (!localName.equals("*") && !element.getLocalName().equals(localName)) continue;
            v.addElement(element);
        }
        return v;
    }

    public ObjectAdapter getObject() {
        return this.rootPlace.getObject();
    }

    public XmlSchema getSchema() {
        return this.schema;
    }

    public String getSchemaLocationFileName() {
        return this.schemaLocationFileName;
    }

    public Document getXmlDocument() {
        return this.xmlDocument;
    }

    public Element getXmlElement() {
        return this.xmlElement;
    }

    public Document getXsdDocument() {
        return this.xsdDocument;
    }

    public Element getXsdElement() {
        return this.xsdElement;
    }

    public void include(String path) {
        this.include(path, null);
    }

    public void include(String path, String annotation) {
        Vector<String> fieldNames = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(path, "/");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (LOG.isDebugEnabled()) {
                LOG.debug("include(..): " + this.log("token", token));
            }
            fieldNames.addElement(token);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("include(..): " + this.log("fieldNames", fieldNames));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("include(..): invoking includeField");
        }
        this.includeField(this.rootPlace, fieldNames, annotation);
    }

    private boolean includeField(Place place, Vector fieldNames, String annotation) {
        Vector xmlFieldElements;
        if (LOG.isDebugEnabled()) {
            LOG.debug("includeField(: " + this.log("place", place) + this.andlog("fieldNames", fieldNames) + this.andlog("annotation", annotation) + ")");
        }
        ObjectAdapter object = place.getObject();
        Element xmlElement = place.getXmlElement();
        Vector originalNames = fieldNames;
        Vector names = new Vector();
        Enumeration e = originalNames.elements();
        while (e.hasMoreElements()) {
            names.addElement(e.nextElement());
        }
        if (names.size() == 0) {
            return true;
        }
        String fieldName = (String)names.elementAt(0);
        names.removeElementAt(0);
        if (LOG.isDebugEnabled()) {
            LOG.debug("includeField(Pl, Vec, Str):" + this.log("processing field", fieldName) + this.andlog("left", "" + names.size()));
        }
        ObjectSpecification nos = object.getSpecification();
        ObjectAssociation field = null;
        try {
            field = nos.getAssociation(fieldName);
        }
        catch (ObjectSpecificationException ex) {
            if (LOG.isInfoEnabled()) {
                LOG.info("includeField(Pl, Vec, Str): could not locate field, skipping");
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("includeField(Pl, Vec, Str): locating corresponding XML element");
        }
        if ((xmlFieldElements = this.elementsUnder(xmlElement, field.getId())).size() != 1) {
            if (LOG.isInfoEnabled()) {
                LOG.info("includeField(Pl, Vec, Str): could not locate " + this.log("field", field.getId()) + this.andlog("xmlFieldElements.size", "" + xmlFieldElements.size()));
            }
            return false;
        }
        Element xmlFieldElement = (Element)xmlFieldElements.elementAt(0);
        if (names.size() == 0 && annotation != null) {
            this.isisMetaModel.setAnnotationAttribute(xmlFieldElement, annotation);
        }
        Place fieldPlace = new Place(object, xmlFieldElement);
        if (field instanceof OneToOneAssociation) {
            OneToOneAssociation oneToOneAssociation;
            ObjectAdapter referencedObject;
            if (field.getSpecification().getAssociations(Contributed.EXCLUDED).size() == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("includeField(Pl, Vec, Str): field is value; done");
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("includeField(Pl, Vec, Str): field is 1->1");
            }
            if ((referencedObject = (oneToOneAssociation = (OneToOneAssociation)field).get(fieldPlace.getObject())) == null) {
                return true;
            }
            boolean appendedXml = this.appendXmlThenIncludeRemaining(fieldPlace, referencedObject, names, annotation);
            if (LOG.isDebugEnabled()) {
                LOG.debug("includeField(Pl, Vec, Str): 1->1: invoked appendXmlThenIncludeRemaining for " + this.log("referencedObj", referencedObject) + this.andlog("returned", "" + appendedXml));
            }
            return appendedXml;
        }
        if (field instanceof OneToManyAssociation) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("includeField(Pl, Vec, Str): field is 1->M");
            }
            OneToManyAssociation oneToManyAssociation = (OneToManyAssociation)field;
            ObjectAdapter collection = oneToManyAssociation.get(fieldPlace.getObject());
            CollectionFacet facet = collection.getSpecification().getFacet(CollectionFacet.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug("includeField(Pl, Vec, Str): 1->M: " + this.log("collection.size", "" + facet.size(collection)));
            }
            boolean allFieldsNavigated = true;
            for (ObjectAdapter referencedObject : facet.iterable(collection)) {
                boolean appendedXml = this.appendXmlThenIncludeRemaining(fieldPlace, referencedObject, names, annotation);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("includeField(Pl, Vec, Str): 1->M: + invoked appendXmlThenIncludeRemaining for " + this.log("referencedObj", referencedObject) + this.andlog("returned", "" + appendedXml));
                }
                allFieldsNavigated = allFieldsNavigated && appendedXml;
            }
            LOG.debug("includeField(Pl, Vec, Str): " + this.log("returning", "" + allFieldsNavigated));
            return allFieldsNavigated;
        }
        return false;
    }

    private String log(String label, ObjectAdapter adapter) {
        return this.log(label, adapter == null ? "(null)" : adapter.titleString() + "[" + this.oidAsString(adapter) + "]");
    }

    private String log(String label, Object pojo) {
        return (label == null ? "?" : label) + "='" + (pojo == null ? "(null)" : pojo.toString()) + "'";
    }

    private Element mergeTree(Element parentElement, Element childElement) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("mergeTree(" + this.log("parent", parentElement) + this.andlog("child", childElement));
        }
        String childElementOid = this.isisMetaModel.getAttribute(childElement, "oid");
        if (LOG.isDebugEnabled()) {
            LOG.debug("mergeTree(El,El): " + this.log("childOid", childElementOid));
        }
        if (childElementOid != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("mergeTree(El,El): check if child already there");
            }
            Vector existingChildElements = this.elementsUnder(parentElement, childElement.getLocalName());
            Enumeration childEnum = existingChildElements.elements();
            while (childEnum.hasMoreElements()) {
                Element possibleMatchingElement = (Element)childEnum.nextElement();
                String possibleMatchOid = this.isisMetaModel.getAttribute(possibleMatchingElement, "oid");
                if (possibleMatchOid == null || !possibleMatchOid.equals(childElementOid)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("mergeTree(El,El): child already there; merging grandchildren");
                }
                Element existingChildElement = possibleMatchingElement;
                Vector grandchildrenElements = this.elementsUnder(childElement, "*");
                Enumeration grandchildEnum = grandchildrenElements.elements();
                while (grandchildEnum.hasMoreElements()) {
                    Element grandchildElement = (Element)grandchildEnum.nextElement();
                    childElement.removeChild(grandchildElement);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("mergeTree(El,El): merging " + this.log("grandchild", grandchildElement));
                    }
                    this.mergeTree(existingChildElement, grandchildElement);
                }
                return existingChildElement;
            }
        }
        parentElement.appendChild(childElement);
        return childElement;
    }

    Place objectToElement(ObjectAdapter adapter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("objectToElement(" + this.log("object", adapter) + ")");
        }
        ObjectSpecification nos = adapter.getSpecification();
        if (LOG.isDebugEnabled()) {
            LOG.debug("objectToElement(NO): create element and isis:title");
        }
        Element element = this.schema.createElement(this.getXmlDocument(), nos.getShortIdentifier(), nos.getFullIdentifier(), nos.getSingularName(), nos.getPluralName());
        this.isisMetaModel.appendIsisTitle(element, adapter.titleString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("objectToElement(NO): create XS element for Isis class");
        }
        Element xsElement = this.schema.createXsElementForNofClass(this.getXsdDocument(), element, this.topLevelElementWritten, FacetUtil.getFacetsByType(nos));
        this.topLevelElementWritten = true;
        Place place = new Place(adapter, element);
        this.isisMetaModel.setAttributesForClass(element, this.oidAsString(adapter).toString());
        List<ObjectAssociation> fields = nos.getAssociations(Contributed.EXCLUDED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("objectToElement(NO): processing fields");
        }
        block6: for (int i = 0; i < fields.size(); ++i) {
            ObjectAssociation field = fields.get(i);
            String fieldName = field.getId();
            if (LOG.isDebugEnabled()) {
                LOG.debug("objectToElement(NO): " + this.log("field", fieldName));
            }
            for (int j = 0; j < i; ++j) {
                if (!fieldName.equals(fields.get(i).getName())) continue;
                LOG.debug("objectToElement(NO): " + this.log("field", fieldName) + " SKIPPED");
                continue block6;
            }
            Element xmlFieldElement = this.getXmlDocument().createElementNS(this.schema.getUri(), this.schema.getPrefix() + ":" + fieldName);
            Element xsdFieldElement = null;
            if (field.getSpecification().containsFacet(ValueFacet.class)) {
                ObjectSpecification fieldNos;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("objectToElement(NO): " + this.log("field", fieldName) + " is value");
                }
                if ((fieldNos = field.getSpecification()) == null || fieldNos.getFullIdentifier() != null && fieldNos.getFullIdentifier().endsWith("XmlValue")) continue;
                OneToOneAssociation valueAssociation = (OneToOneAssociation)field;
                Element xmlValueElement = xmlFieldElement;
                try {
                    boolean notEmpty;
                    ObjectAdapter value = valueAssociation.get(adapter);
                    ObjectSpecification valueNos = value.getSpecification();
                    this.isisMetaModel.setAttributesForValue(xmlValueElement, valueNos.getShortIdentifier());
                    ParseableFacet parseableFacet = fieldNos.getFacet(ParseableFacet.class);
                    EncodableFacet encodeableFacet = fieldNos.getFacet(EncodableFacet.class);
                    String valueStr = parseableFacet != null ? parseableFacet.parseableTitle(value) : (encodeableFacet != null ? encodeableFacet.toEncodedString(value) : value.titleString());
                    boolean bl = notEmpty = valueStr.length() > 0;
                    if (notEmpty) {
                        xmlValueElement.appendChild(this.getXmlDocument().createTextNode(valueStr));
                    } else {
                        this.isisMetaModel.setIsEmptyAttribute(xmlValueElement, true);
                    }
                }
                catch (Exception ex) {
                    LOG.warn("objectToElement(NO): " + this.log("field", fieldName) + ": getField() threw exception - skipping XML generation");
                }
                xsdFieldElement = this.schema.createXsElementForNofValue(xsElement, xmlValueElement, FacetUtil.getFacetsByType(valueAssociation));
            } else if (field instanceof OneToOneAssociation) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("objectToElement(NO): " + this.log("field", fieldName) + " is OneToOneAssociation");
                }
                OneToOneAssociation oneToOneAssociation = (OneToOneAssociation)field;
                String fullyQualifiedClassName = nos.getFullIdentifier();
                Element xmlReferenceElement = xmlFieldElement;
                try {
                    ObjectAdapter referencedObjectAdapter = oneToOneAssociation.get(adapter);
                    this.isisMetaModel.setAttributesForReference(xmlReferenceElement, this.schema.getPrefix(), fullyQualifiedClassName);
                    if (referencedObjectAdapter != null) {
                        this.isisMetaModel.appendIsisTitle(xmlReferenceElement, referencedObjectAdapter.titleString());
                    } else {
                        this.isisMetaModel.setIsEmptyAttribute(xmlReferenceElement, true);
                    }
                }
                catch (Exception ex) {
                    LOG.warn("objectToElement(NO): " + this.log("field", fieldName) + ": getAssociation() threw exception - skipping XML generation");
                }
                xsdFieldElement = this.schema.createXsElementForNofReference(xsElement, xmlReferenceElement, oneToOneAssociation.getSpecification().getFullIdentifier(), FacetUtil.getFacetsByType(oneToOneAssociation));
            } else if (field instanceof OneToManyAssociation) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("objectToElement(NO): " + this.log("field", fieldName) + " is OneToManyAssociation");
                }
                OneToManyAssociation oneToManyAssociation = (OneToManyAssociation)field;
                Element xmlCollectionElement = xmlFieldElement;
                try {
                    ObjectAdapter collection = oneToManyAssociation.get(adapter);
                    ObjectSpecification referencedTypeNos = oneToManyAssociation.getSpecification();
                    String fullyQualifiedClassName = referencedTypeNos.getFullIdentifier();
                    this.isisMetaModel.setIsisCollection(xmlCollectionElement, this.schema.getPrefix(), fullyQualifiedClassName, collection);
                }
                catch (Exception ex) {
                    LOG.warn("objectToElement(NO): " + this.log("field", fieldName) + ": get(obj) threw exception - skipping XML generation");
                }
                xsdFieldElement = this.schema.createXsElementForNofCollection(xsElement, xmlCollectionElement, oneToManyAssociation.getSpecification().getFullIdentifier(), FacetUtil.getFacetsByType(oneToManyAssociation));
            } else {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("objectToElement(NO): " + this.log("field", fieldName) + " is unknown type; ignored");
                continue;
            }
            if (xsdFieldElement != null) {
                Place.setXsdElement(xmlFieldElement, xsdFieldElement);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("objectToElement(NO): invoking mergeTree for field");
            }
            xmlFieldElement = this.mergeTree(element, xmlFieldElement);
            if (xsdFieldElement == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("objectToElement(NO): adding XS element for field to schema");
            }
            this.schema.addFieldXsElement(xsElement, xsdFieldElement);
        }
        return place;
    }

    private String oidAsString(ObjectAdapter adapter) {
        if (adapter.getObject() instanceof ViewModel) {
            String fakeOid = this.viewModelFakeOids.get(adapter);
            if (fakeOid == null) {
                fakeOid = "viewmodel-fakeoid-" + UUID.randomUUID().toString();
                this.viewModelFakeOids.put(adapter, fakeOid);
            }
            return fakeOid;
        }
        return adapter.getOid().enString(this.oidMarshaller);
    }

    private void setSchemaLocationFileName(String schemaLocationFileName) {
        this.schemaLocationFileName = schemaLocationFileName;
    }

    private void setXmlElement(Element xmlElement) {
        this.xmlElement = xmlElement;
    }

    public String getXmlDocumentAsString() {
        Document doc = this.getXmlDocument();
        return XmlSnapshot.asString(doc);
    }

    public String getXsdDocumentAsString() {
        Document doc = this.getXsdDocument();
        return XmlSnapshot.asString(doc);
    }

    private static String asString(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new IsisException(e);
        }
        catch (TransformerException e) {
            throw new IsisException(e);
        }
    }
}

