/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.progmodels.dflt;

import java.util.Collection;
import java.util.Set;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.ClassSubstitutorFactory;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecorator;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.ObjectReflectorDefault;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryDefault;
import org.apache.isis.core.metamodel.specloader.traverser.SpecificationTraverserDefault;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaReflectorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JavaReflectorHelper.class);

    private JavaReflectorHelper() {
    }

    public static SpecificationLoaderSpi createObjectReflector(ProgrammingModel programmingModel, ClassSubstitutorFactory classSubstitutorFactory, Collection<MetaModelRefiner> metaModelRefiners, Set<FacetDecorator> facetDecorators, MetaModelValidator mmv, IsisConfiguration configuration) {
        SpecificationTraverserDefault specificationTraverser = new SpecificationTraverserDefault();
        CollectionTypeRegistryDefault collectionTypeRegistry = new CollectionTypeRegistryDefault();
        ClassSubstitutor classSubstitutor = classSubstitutorFactory.createClassSubstitutor(configuration);
        MetaModelValidatorComposite metaModelValidator = MetaModelValidatorComposite.asComposite(mmv);
        for (MetaModelRefiner metaModelRefiner : metaModelRefiners) {
            metaModelRefiner.refineProgrammingModel(programmingModel, configuration);
            metaModelRefiner.refineMetaModelValidator(metaModelValidator, configuration);
        }
        if (!metaModelRefiners.contains(programmingModel)) {
            programmingModel.refineMetaModelValidator(metaModelValidator, configuration);
        }
        return new ObjectReflectorDefault(configuration, classSubstitutor, collectionTypeRegistry, specificationTraverser, programmingModel, facetDecorators, metaModelValidator);
    }
}

