/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.progmodels.dflt;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.isis.core.commons.config.InstallerAbstract;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facetapi.ClassSubstitutorFactory;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecorator;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.FacetDecoratorInstaller;
import org.apache.isis.core.metamodel.specloader.ObjectReflectorInstaller;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.progmodels.dflt.JavaReflectorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaReflectorInstallerNoDecorators
extends InstallerAbstract
implements ObjectReflectorInstaller {
    private static final Logger LOG = LoggerFactory.getLogger(JavaReflectorInstallerNoDecorators.class);
    public static final String PROPERTY_BASE = "isis.";
    protected final LinkedHashSet<FacetDecoratorInstaller> decoratorInstallers = Sets.newLinkedHashSet();

    public JavaReflectorInstallerNoDecorators() {
        this("java");
    }

    public JavaReflectorInstallerNoDecorators(String name) {
        super("reflector", name);
    }

    @Override
    public SpecificationLoaderSpi createReflector(ClassSubstitutorFactory classSubstitutorFactory, Collection<MetaModelRefiner> metaModelRefiners) {
        ProgrammingModel programmingModel = this.createProgrammingModel(this.getConfiguration());
        Set<FacetDecorator> facetDecorators = this.createFacetDecorators(this.getConfiguration());
        MetaModelValidator mmv = this.createMetaModelValidator(this.getConfiguration());
        return JavaReflectorHelper.createObjectReflector(programmingModel, classSubstitutorFactory, metaModelRefiners, facetDecorators, mmv, this.getConfiguration());
    }

    protected ProgrammingModel createProgrammingModel(IsisConfiguration configuration) {
        ProgrammingModel programmingModel = this.lookupAndCreateProgrammingModelFacets(configuration);
        this.includeFacetFactories(configuration, programmingModel);
        this.excludeFacetFactories(configuration, programmingModel);
        return programmingModel;
    }

    private ProgrammingModel lookupAndCreateProgrammingModelFacets(IsisConfiguration configuration) {
        String progModelFacetsClassName = configuration.getString("isis.reflector.facets", "org.apache.isis.progmodels.dflt.ProgrammingModelFacetsJava5");
        ProgrammingModel programmingModel = InstanceUtil.createInstance(progModelFacetsClassName, ProgrammingModel.class);
        return programmingModel;
    }

    protected void includeFacetFactories(IsisConfiguration configuration, ProgrammingModel programmingModel) {
        String[] facetFactoriesIncludeClassNames = configuration.getList("isis.reflector.facets.include");
        if (facetFactoriesIncludeClassNames != null) {
            for (String facetFactoryClassName : facetFactoriesIncludeClassNames) {
                Class facetFactory = InstanceUtil.loadClass(facetFactoryClassName, FacetFactory.class);
                programmingModel.addFactory(facetFactory);
            }
        }
    }

    protected void excludeFacetFactories(IsisConfiguration configuration, ProgrammingModel programmingModel) {
        String[] facetFactoriesExcludeClassNames;
        for (String facetFactoryClassName : facetFactoriesExcludeClassNames = configuration.getList("isis.reflector.facets.exclude")) {
            Class facetFactory = InstanceUtil.loadClass(facetFactoryClassName, FacetFactory.class);
            programmingModel.removeFactory(facetFactory);
        }
    }

    protected Set<FacetDecorator> createFacetDecorators(IsisConfiguration configuration) {
        return Collections.emptySet();
    }

    protected MetaModelValidator createMetaModelValidator(IsisConfiguration configuration) {
        String metaModelValidatorClassName = configuration.getString("isis.reflector.validator", "org.apache.isis.core.progmodel.metamodelvalidator.dflt.MetaModelValidatorDefault");
        return InstanceUtil.createInstance(metaModelValidatorClassName, MetaModelValidator.class);
    }

    @Override
    public void addFacetDecoratorInstaller(FacetDecoratorInstaller decoratorInstaller) {
        if (decoratorInstaller == null) {
            return;
        }
        this.decoratorInstallers.add(decoratorInstaller);
    }

    @Override
    public List<Class<?>> getTypes() {
        return JavaReflectorInstallerNoDecorators.listOf(SpecificationLoaderSpi.class);
    }
}

