/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.config;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderAware;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.config.NotFoundPolicy;
import org.apache.isis.core.commons.config.PropertiesReader;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.resource.ResourceStreamSource;
import org.apache.isis.core.commons.resource.ResourceStreamSourceChainOfResponsibility;
import org.apache.isis.core.commons.resource.ResourceStreamSourceFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisConfigurationBuilderResourceStreams
implements IsisConfigurationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(IsisConfigurationBuilderResourceStreams.class);
    private final Set<String> configurationResourcesFound = Sets.newLinkedHashSet();
    private final Set<String> configurationResourcesNotFound = Sets.newLinkedHashSet();
    private final ResourceStreamSource resourceStreamSource;
    private final IsisConfigurationDefault configuration;
    private final List<ConfigurationResourceAndPolicy> configurationResources = new ArrayList<ConfigurationResourceAndPolicy>();
    private boolean locked;

    private static ResourceStreamSource createComposite(ResourceStreamSource ... resourceStreamSources) {
        ResourceStreamSourceChainOfResponsibility composite = new ResourceStreamSourceChainOfResponsibility(new ResourceStreamSource[0]);
        for (ResourceStreamSource rss : resourceStreamSources) {
            if (rss == null) continue;
            composite.addResourceStreamSource(rss);
        }
        return composite;
    }

    public IsisConfigurationBuilderResourceStreams() {
        this(ResourceStreamSourceFileSystem.create("config"));
    }

    public IsisConfigurationBuilderResourceStreams(ResourceStreamSource ... resourceStreamSources) {
        this(IsisConfigurationBuilderResourceStreams.createComposite(resourceStreamSources));
    }

    public IsisConfigurationBuilderResourceStreams(ResourceStreamSource resourceStreamSource) {
        this.resourceStreamSource = resourceStreamSource;
        this.configuration = new IsisConfigurationDefault(resourceStreamSource);
    }

    @Override
    public void addDefaultConfigurationResources() {
        this.addConfigurationResource("isis.properties", NotFoundPolicy.FAIL_FAST);
        this.addConfigurationResource("web.properties", NotFoundPolicy.CONTINUE);
    }

    @Override
    public ResourceStreamSource getResourceStreamSource() {
        return this.resourceStreamSource;
    }

    @Override
    public synchronized void addConfigurationResource(String configurationResource, NotFoundPolicy notFoundPolicy) {
        LOG.debug("looking for properties file " + configurationResource);
        this.loadConfigurationResource(this.configuration, new ConfigurationResourceAndPolicy(configurationResource, notFoundPolicy));
        this.configurationResources.add(new ConfigurationResourceAndPolicy(configurationResource, notFoundPolicy));
    }

    @Override
    public synchronized void add(String key, String value) {
        if (this.locked) {
            throw new IsisException("Configuration has been locked and cannot be changed");
        }
        this.configuration.add(key, value);
    }

    @Override
    public void lockConfiguration() {
        this.locked = true;
    }

    @Override
    public synchronized IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    private void loadConfigurationResource(IsisConfigurationDefault configuration, ConfigurationResourceAndPolicy configResourceAndPolicy) {
        String configurationResource = configResourceAndPolicy.getConfigurationResource();
        NotFoundPolicy notFoundPolicy = configResourceAndPolicy.getNotFoundPolicy();
        LOG.debug("checking availability of configuration resource: " + configurationResource + ", notFoundPolicy: " + (Object)((Object)notFoundPolicy));
        this.loadConfigurationResource(configuration, configurationResource, notFoundPolicy);
    }

    protected void loadConfigurationResource(IsisConfigurationDefault configuration, String configurationResource, NotFoundPolicy notFoundPolicy) {
        try {
            PropertiesReader propertiesReader = this.loadConfigurationResource(this.resourceStreamSource, configurationResource);
            LOG.info("loading properties from " + configurationResource);
            configuration.add(propertiesReader.getProperties());
            this.configurationResourcesFound.add(configurationResource);
            return;
        }
        catch (IOException ignore) {
            if (notFoundPolicy == NotFoundPolicy.FAIL_FAST) {
                throw new IsisException("failed to load '" + configurationResource + "'; tried using: " + this.resourceStreamSource.getName());
            }
            this.configurationResourcesNotFound.add(configurationResource);
            LOG.debug("'" + configurationResource + "' not found, but not needed");
            return;
        }
    }

    private PropertiesReader loadConfigurationResource(ResourceStreamSource resourceStreamSource, String configurationResource) throws IOException {
        return new PropertiesReader(resourceStreamSource, configurationResource);
    }

    private void addShowExplorationOptionsIfNotSpecified(IsisConfigurationDefault configuration) {
        if (configuration.getString("isis.exploration.show") == null) {
            configuration.add("isis.exploration.show", "yes");
        }
    }

    @Override
    public void dumpResourcesToLog() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Configuration resources FOUND:");
            for (String resource : this.configurationResourcesFound) {
                LOG.info("*  " + resource);
            }
            LOG.info("Configuration resources NOT FOUND (but not needed):");
            for (String resource : this.configurationResourcesNotFound) {
                LOG.info("*  " + resource);
            }
        }
    }

    @Override
    public void injectInto(Object candidate) {
        if (IsisConfigurationBuilderAware.class.isAssignableFrom(candidate.getClass())) {
            IsisConfigurationBuilderAware cast = (IsisConfigurationBuilderAware)IsisConfigurationBuilderAware.class.cast(candidate);
            cast.setConfigurationBuilder(this);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("resourceStream", (Object)this.resourceStreamSource).add("configResources", this.configurationResources).toString();
    }

    static class ConfigurationResourceAndPolicy {
        private final String configurationResource;
        private final NotFoundPolicy notFoundPolicy;

        public ConfigurationResourceAndPolicy(String configurationResource, NotFoundPolicy notFoundPolicy) {
            this.configurationResource = configurationResource;
            this.notFoundPolicy = notFoundPolicy;
        }

        public String getConfigurationResource() {
            return this.configurationResource;
        }

        public NotFoundPolicy getNotFoundPolicy() {
            return this.notFoundPolicy;
        }

        public String toString() {
            return String.format("%s{%s}", new Object[]{this.configurationResource, this.notFoundPolicy});
        }
    }
}

