/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.config;

import com.google.common.collect.Maps;
import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.commons.config.IsisConfigurationException;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.resource.ResourceStreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisConfigurationDefault
implements IsisConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(IsisConfigurationDefault.class);
    private final Properties properties = new Properties();
    private final ResourceStreamSource resourceStreamSource;

    public IsisConfigurationDefault() {
        this(null);
    }

    public IsisConfigurationDefault(ResourceStreamSource resourceStreamSource) {
        this.resourceStreamSource = resourceStreamSource;
        LOG.debug("configuration initialised with stream: " + this.nameOf(resourceStreamSource));
    }

    private String nameOf(ResourceStreamSource resourceStreamSource) {
        return resourceStreamSource != null ? resourceStreamSource.getName() : null;
    }

    @Override
    public ResourceStreamSource getResourceStreamSource() {
        return this.resourceStreamSource;
    }

    public void add(Properties properties) {
        this.add(properties, ContainsPolicy.IGNORE);
    }

    public void put(Properties properties) {
        this.add(properties, ContainsPolicy.OVERWRITE);
    }

    public void add(Properties properties, ContainsPolicy policy) {
        for (Object key : properties.keySet()) {
            Object value = properties.get(key);
            this.add((String)key, (String)value);
        }
    }

    public void add(String key, String value) {
        this.add(key, value, ContainsPolicy.IGNORE);
    }

    public void put(String key, String value) {
        this.add(key, value, ContainsPolicy.OVERWRITE);
    }

    public void add(String key, String value, ContainsPolicy policy) {
        if (value == null) {
            LOG.debug("ignoring " + key + " as value is null");
            return;
        }
        if (key == null) {
            return;
        }
        if (this.properties.containsKey(key)) {
            switch (policy) {
                case IGNORE: {
                    LOG.info("ignoring " + key + "=" + value + " as value already set (with " + this.properties.get(key) + ")");
                    break;
                }
                case OVERWRITE: {
                    LOG.info("overwriting " + key + "=" + value + " (previous value was " + this.properties.get(key) + ")");
                    this.properties.put(key, value);
                    break;
                }
                case EXCEPTION: {
                    throw new IllegalStateException("Configuration already has a key " + key + ", value of " + this.properties.get(key));
                }
            }
        } else {
            LOG.info("adding " + key + "=" + value);
            this.properties.put(key, value);
        }
    }

    @Override
    public IsisConfiguration createSubset(String prefix) {
        IsisConfigurationDefault subset = new IsisConfigurationDefault(this.resourceStreamSource);
        String startsWith = prefix;
        if (!startsWith.endsWith(".")) {
            startsWith = startsWith + '.';
        }
        int prefixLength = startsWith.length();
        for (Object keyObj : this.properties.keySet()) {
            String key = (String)keyObj;
            if (!key.startsWith(startsWith)) continue;
            String modifiedKey = key.substring(prefixLength);
            subset.properties.put(modifiedKey, this.properties.get(key));
        }
        return subset;
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.toLowerCase()).equals("on") || value.equals("yes") || value.equals("true") || value.equals("")) {
            return true;
        }
        if (value.equals("off") || value.equals("no") || value.equals("false")) {
            return false;
        }
        throw new IsisConfigurationException("Illegal flag for " + name + "; must be one of on, off, yes, no, true or false");
    }

    @Override
    public Color getColor(String name) {
        return this.getColor(name, null);
    }

    @Override
    public Color getColor(String name, Color defaultValue) {
        String color = this.getProperty(name);
        if (color == null) {
            return defaultValue;
        }
        return Color.decode(color);
    }

    @Override
    public void debugData(DebugBuilder str) {
        str.appendln("Resource Stream Source", this.resourceStreamSource);
        str.appendln();
        Enumeration<?> names = this.properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            str.appendln(name, this.properties.getProperty(name));
        }
    }

    @Override
    public String debugTitle() {
        return "Properties Configuration";
    }

    @Override
    public Font getFont(String name) {
        return this.getFont(name, null);
    }

    @Override
    public Font getFont(String name, Font defaultValue) {
        String font = this.getProperty(name);
        if (font == null) {
            return defaultValue;
        }
        return Font.decode(font);
    }

    @Override
    public int getInteger(String name) {
        return this.getInteger(name, 0);
    }

    @Override
    public int getInteger(String name, int defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    @Override
    public String[] getList(String name) {
        String list = this.getString(name);
        if (list == null) {
            return new String[0];
        }
        StringTokenizer tokens = new StringTokenizer(list, ",");
        String[] array = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            array[i++] = tokens.nextToken().trim();
        }
        return array;
    }

    @Override
    public IsisConfiguration getProperties(String withPrefix) {
        int prefixLength = "".length();
        Properties pp = new Properties();
        Enumeration<Object> e = this.properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(withPrefix)) continue;
            String modifiedKey = key.substring(prefixLength);
            pp.put(modifiedKey, this.properties.get(key));
        }
        IsisConfigurationDefault isisConfigurationDefault = new IsisConfigurationDefault(this.resourceStreamSource);
        isisConfigurationDefault.add(pp);
        return isisConfigurationDefault;
    }

    private String getProperty(String name) {
        return this.getProperty(name, null);
    }

    private String getProperty(String name, String defaultValue) {
        String key = this.referedToAs(name);
        if (key.indexOf("..") >= 0) {
            throw new IsisException("property names should not have '..' within them: " + name);
        }
        String property = this.properties.getProperty(key, defaultValue);
        property = property != null ? property.trim() : null;
        LOG.debug("get property: '" + key + "' =  '" + property + "'");
        return property;
    }

    @Override
    public String getString(String name) {
        return this.getProperty(name);
    }

    @Override
    public String getString(String name, String defaultValue) {
        return this.getProperty(name, defaultValue);
    }

    @Override
    public boolean hasProperty(String name) {
        String key = this.referedToAs(name);
        return this.properties.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.properties.stringPropertyNames().iterator();
    }

    private String referedToAs(String name) {
        return name;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    public String toString() {
        return "ConfigurationParameters [properties=" + this.properties + "]";
    }

    @Override
    public void injectInto(Object candidate) {
        if (IsisConfigurationAware.class.isAssignableFrom(candidate.getClass())) {
            IsisConfigurationAware cast = (IsisConfigurationAware)IsisConfigurationAware.class.cast(candidate);
            cast.setConfiguration(this);
        }
    }

    @Override
    public Map<String, String> asMap() {
        HashMap map = Maps.newHashMap();
        for (String propertyName : this) {
            String propertyValue = this.getProperty(propertyName);
            map.put(propertyName, propertyValue);
        }
        return map;
    }

    public static enum ContainsPolicy {
        IGNORE,
        OVERWRITE,
        EXCEPTION;

    }
}

