/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.encoding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.isis.core.commons.encoding.DataInputStreamExtended;
import org.apache.isis.core.commons.encoding.DataOutputStreamExtended;
import org.apache.isis.core.commons.exceptions.IsisException;

public final class HexUtils {
    private HexUtils() {
    }

    public static String encoded(Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStreamExtended outputImpl = new DataOutputStreamExtended(baos);
        try {
            outputImpl.writeEncodable(object);
            byte[] byteArray = baos.toByteArray();
            return new String(Hex.encodeHex((byte[])byteArray));
        }
        catch (IOException e) {
            throw new IsisException("Failed to write object", e);
        }
    }

    public static <T> T decoded(String hexEncoded, Class<T> cls) {
        char[] chars = hexEncoded.toCharArray();
        try {
            byte[] bytes = Hex.decodeHex((char[])chars);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStreamExtended inputImpl = new DataInputStreamExtended(bais);
            return inputImpl.readEncodable(cls);
        }
        catch (IOException ex) {
            throw new IsisException("Failed to read object", ex);
        }
        catch (DecoderException ex) {
            throw new IsisException("Failed to hex decode object", ex);
        }
    }
}

