/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.isis.core.commons.ensure.Ensure;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class LazyInputStream
extends InputStream {
    private final InputStreamProvider provider;
    private InputStream underlying = null;

    public LazyInputStream(InputStreamProvider provider) {
        Ensure.ensureThatArg(provider, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.provider = provider;
    }

    @Override
    public void close() throws IOException {
        this.obtainUnderlyingIfRequired();
        this.underlying.close();
    }

    @Override
    public int available() throws IOException {
        this.obtainUnderlyingIfRequired();
        return this.underlying.available();
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.obtainUnderlyingIfRequired();
            this.underlying.mark(readlimit);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean markSupported() {
        try {
            this.obtainUnderlyingIfRequired();
            return this.underlying.markSupported();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int read() throws IOException {
        this.obtainUnderlyingIfRequired();
        return this.underlying.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.obtainUnderlyingIfRequired();
        return this.underlying.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.obtainUnderlyingIfRequired();
        return this.underlying.read(b);
    }

    @Override
    public long skip(long n) throws IOException {
        this.obtainUnderlyingIfRequired();
        return this.underlying.skip(n);
    }

    @Override
    public void reset() throws IOException {
        this.obtainUnderlyingIfRequired();
        this.underlying.reset();
    }

    private void obtainUnderlyingIfRequired() throws IOException {
        if (this.underlying == null) {
            this.underlying = this.provider.getInputStream();
        }
    }

    public boolean equals(Object obj) {
        try {
            this.obtainUnderlyingIfRequired();
            return this.underlying.equals(obj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        try {
            this.obtainUnderlyingIfRequired();
            return this.underlying.hashCode();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        try {
            this.obtainUnderlyingIfRequired();
            return this.underlying.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface InputStreamProvider {
        public InputStream getInputStream() throws IOException;
    }
}

