/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.lang.ClassFunctions;
import org.apache.isis.core.commons.lang.ClassPredicates;

public final class ListExtensions {
    private static final String DEFAULT_DELIMITER = ",";

    private ListExtensions() {
    }

    public static <T> List<T> combineWith(List<T> extendee, List<T> list2) {
        ArrayList combinedList = Lists.newArrayList();
        combinedList.addAll(extendee);
        combinedList.addAll(list2);
        return combinedList;
    }

    public static <T> List<T> mergeWith(List<T> extendee, List<T> list2) {
        for (T obj : list2) {
            if (extendee.contains(obj)) continue;
            extendee.add(obj);
        }
        return extendee;
    }

    public static String listToString(List<String> list) {
        return ListExtensions.listToString(list, DEFAULT_DELIMITER);
    }

    public static String listToString(List<String> list, String delimiter) {
        if (list.size() == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String str : list) {
            if (first) {
                first = false;
            } else {
                buf.append(delimiter);
            }
            buf.append(str);
        }
        return buf.toString();
    }

    public static List<String> stringToList(String commaSeparated) {
        return ListExtensions.appendDelimitedStringToList(commaSeparated, new ArrayList<String>());
    }

    public static List<String> stringToList(String delimited, String delimiter) {
        return ListExtensions.appendDelimitedStringToList(delimited, delimiter, new ArrayList<String>());
    }

    public static List<String> appendDelimitedStringToList(String commaSeparated, List<String> list) {
        return ListExtensions.appendDelimitedStringToList(commaSeparated, DEFAULT_DELIMITER, list);
    }

    public static List<String> appendDelimitedStringToList(String delimited, String delimiter, List<String> list) {
        if (delimited == null) {
            return list;
        }
        String[] optionValues = delimited.split(delimiter);
        list.addAll(Arrays.asList(optionValues));
        return list;
    }

    public static <T> List<T> mutableCopy(List<T> input) {
        return Lists.newArrayList(input != null ? input : Collections.emptyList());
    }

    public static <T> List<T> mutableCopy(T[] arr) {
        return ListExtensions.mutableCopy(arr != null ? Arrays.asList(arr) : Collections.emptyList());
    }

    public static <T> void insert(List<T> list, int insertionPoint, T elementToInsert) {
        ListExtensions.extend(list, insertionPoint);
        list.add(insertionPoint, elementToInsert);
    }

    public static <T> void adjust(List<T> list, int requiredLength) {
        ListExtensions.extend(list, requiredLength);
        if (list.size() > requiredLength) {
            list.subList(requiredLength, list.size()).clear();
        }
    }

    private static <T> void extend(List<T> list, int requiredLength) {
        for (int i = list.size(); i < requiredLength; ++i) {
            list.add(null);
        }
    }

    public static <T> Collection<T> filtered(List<Object> extendee, Class<T> type) {
        return Collections2.transform((Collection)Collections2.filter(extendee, ClassPredicates.isOfType(type)), ClassFunctions.castTo(type));
    }
}

