/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.url;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class UrlEncodingUtils {
    public static final Function<String, String> FUNCTION = new Function<String, String>(){

        public String apply(String input) {
            try {
                return URLDecoder.decode(input, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
    };

    private UrlEncodingUtils() {
    }

    public static String urlDecode(String string) {
        return (String)FUNCTION.apply((Object)string);
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

