/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.util;

import java.util.Date;
import org.apache.isis.core.commons.lang.DateExtensions;
import org.apache.isis.core.commons.lang.ObjectExtensions;

public final class ToString {
    private boolean addComma = false;
    private final StringBuffer buf = new StringBuffer();
    private boolean useLineBreaks;

    public static ToString createAnonymous(Object object) {
        ToString string = new ToString();
        string.append(ObjectExtensions.classBaseName(object));
        string.append("[");
        return string;
    }

    private ToString() {
    }

    public ToString(Object forObject) {
        ObjectExtensions.appendToString(forObject, this.buf);
        this.buf.append("[");
    }

    public ToString(Object forObject, int id) {
        this.buf.append(ObjectExtensions.classBaseName(forObject));
        this.buf.append("#");
        this.buf.append(id);
        this.buf.append("[");
    }

    public ToString(Object forObject, String text) {
        this(forObject);
        this.buf.append(text);
        this.addComma = text.length() > 0;
    }

    public ToString append(String text) {
        this.buf.append(text);
        return this;
    }

    public ToString append(String name, boolean flag) {
        this.append(name, flag ? "true" : "false");
        return this;
    }

    public ToString append(String name, byte number) {
        this.append(name, Byte.toString(number));
        return this;
    }

    public ToString append(String name, double number) {
        this.append(name, Double.toString(number));
        return this;
    }

    public ToString append(String name, float number) {
        this.append(name, Float.toString(number));
        return this;
    }

    public ToString append(String name, int number) {
        this.append(name, Integer.toString(number));
        return this;
    }

    public ToString append(String name, long number) {
        this.append(name, Long.toString(number));
        return this;
    }

    public ToString append(String name, Object object) {
        this.append(name, object == null ? "null" : object.toString());
        return this;
    }

    public ToString append(String name, short number) {
        this.append(name, Short.toString(number));
        return this;
    }

    public ToString append(String name, String string) {
        if (this.addComma) {
            this.buf.append(',');
            if (this.useLineBreaks) {
                this.buf.append("\n\t");
            }
        } else {
            this.addComma = true;
        }
        this.buf.append(name);
        this.buf.append('=');
        this.buf.append(string);
        return this;
    }

    public ToString appendAsHex(String name, long number) {
        this.append(name, "#" + Long.toHexString(number));
        return this;
    }

    public void appendAsTimestamp(String name, Date date) {
        String dateString = DateExtensions.asTimestamp(date);
        this.append(name, dateString);
    }

    public void appendTruncated(String name, String string, int maxLength) {
        if (string.length() > maxLength) {
            this.append(name, string.substring(0, maxLength));
            this.append("...");
        } else {
            this.append(name, string);
        }
    }

    public void setAddComma() {
        this.addComma = true;
    }

    public void setUseLineBreaks(boolean useLineBreaks) {
        this.useLineBreaks = useLineBreaks;
    }

    public String toString() {
        this.buf.append(']');
        return this.buf.toString();
    }
}

