/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.spec.ElementSpecificationProvider;
import org.apache.isis.core.metamodel.spec.Instance;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.Specification;

public interface ObjectAdapter
extends Instance,
When.Persistable {
    @Override
    public ObjectSpecification getSpecification();

    public Object getObject();

    @Deprecated
    public String titleString();

    public String titleString(ObjectAdapter var1);

    public Instance getInstance(Specification var1);

    public void replacePojo(Object var1);

    public ObjectSpecification getElementSpecification();

    public void setElementSpecificationProvider(ElementSpecificationProvider var1);

    public String getIconName();

    public void changeState(ResolveState var1);

    public void checkLock(Version var1);

    public Oid getOid();

    public void replaceOid(Oid var1);

    public ResolveState getResolveState();

    public boolean representsPersistent();

    public boolean isNew();

    public boolean isTransient();

    public boolean isGhost();

    public boolean isResolved();

    public boolean isResolving();

    public boolean isUpdating();

    public boolean isDestroyed();

    public boolean canTransitionToResolving();

    public boolean isTitleAvailable();

    public void markAsResolvedIfPossible();

    public Version getVersion();

    public void setVersion(Version var1);

    public void fireChangedEvent();

    public boolean isParented();

    public boolean isAggregated();

    public boolean isValue();

    public ObjectAdapter getAggregateRoot();

    public boolean respondToChangesInPersistentObjects();

    public static class Functions {
        private Functions() {
        }

        public static Function<ObjectAdapter, Object> getObject() {
            return new Function<ObjectAdapter, Object>(){

                public Object apply(ObjectAdapter input) {
                    return Util.unwrap(input);
                }
            };
        }

        public static Function<Object, ObjectAdapter> adapterForUsing(final AdapterManager adapterManager) {
            return new Function<Object, ObjectAdapter>(){

                public ObjectAdapter apply(Object pojo) {
                    return adapterManager.adapterFor(pojo);
                }
            };
        }
    }

    public static final class Util {
        private Util() {
        }

        public static Object unwrap(ObjectAdapter adapter) {
            return adapter != null ? adapter.getObject() : null;
        }

        public static Object[] unwrap(ObjectAdapter[] adapters) {
            if (adapters == null) {
                return null;
            }
            Object[] unwrappedObjects = new Object[adapters.length];
            int i = 0;
            for (ObjectAdapter adapter : adapters) {
                unwrappedObjects[i++] = Util.unwrap(adapter);
            }
            return unwrappedObjects;
        }

        public static List<Object> unwrap(List<ObjectAdapter> adapters) {
            ArrayList objects = Lists.newArrayList();
            for (ObjectAdapter adapter : adapters) {
                objects.add(Util.unwrap(adapter));
            }
            return objects;
        }

        public static <T> List<T> unwrapT(List<ObjectAdapter> adapters) {
            return Util.unwrap(adapters);
        }

        public static String unwrapAsString(ObjectAdapter adapter) {
            Object obj = Util.unwrap(adapter);
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof String)) {
                return null;
            }
            return (String)obj;
        }

        public static String titleString(ObjectAdapter adapter) {
            return adapter != null ? adapter.titleString(null) : "";
        }

        public static boolean exists(ObjectAdapter adapter) {
            return adapter != null && adapter.getObject() != null;
        }

        public static boolean wrappedEqual(ObjectAdapter adapter1, ObjectAdapter adapter2) {
            boolean defined1 = Util.exists(adapter1);
            boolean defined2 = Util.exists(adapter2);
            if (defined1 && !defined2) {
                return false;
            }
            if (!defined1 && defined2) {
                return false;
            }
            if (!defined1 && !defined2) {
                return true;
            }
            return adapter1.getObject().equals(adapter2.getObject());
        }

        public static boolean nullSafeEquals(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return true;
            }
            if (obj1 == null || obj2 == null) {
                return false;
            }
            if (obj1.equals(obj2)) {
                return true;
            }
            if (obj1 instanceof ObjectAdapter && obj2 instanceof ObjectAdapter) {
                ObjectAdapter adapterObj1 = (ObjectAdapter)obj1;
                ObjectAdapter adapterObj2 = (ObjectAdapter)obj2;
                return Util.nullSafeEquals(adapterObj1.getObject(), adapterObj2.getObject());
            }
            return false;
        }
    }
}

