/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.callbacks;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackFacet;
import org.apache.isis.core.metamodel.spec.DomainModelException;

public final class CallbackUtils {
    private CallbackUtils() {
    }

    public static void callCallback(ObjectAdapter object, Class<? extends Facet> cls) {
        CallbackFacet facet = (CallbackFacet)object.getSpecification().getFacet(cls);
        if (facet != null) {
            try {
                facet.invoke(object);
            }
            catch (RuntimeException e) {
                throw new DomainModelException("Callback failed.  Calling " + facet + " on " + object, e);
            }
        }
    }
}

