/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.immutable;

import org.apache.isis.applib.annotation.When;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class ImmutableFacetUtils {
    public static boolean isAlwaysImmutable(ObjectSpecification specification) {
        if (specification == null) {
            return false;
        }
        ImmutableFacet immutableFacet = specification.getFacet(ImmutableFacet.class);
        if (immutableFacet == null) {
            return false;
        }
        return immutableFacet.when() == When.ALWAYS;
    }

    public static boolean isImmutableOncePersisted(ObjectSpecification specification) {
        if (specification == null) {
            return false;
        }
        ImmutableFacet immutableFacet = specification.getFacet(ImmutableFacet.class);
        if (immutableFacet == null) {
            return false;
        }
        return immutableFacet.when() == When.ONCE_PERSISTED;
    }

    private ImmutableFacetUtils() {
    }
}

