/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.interactions;

import java.util.List;
import org.apache.isis.applib.events.InteractionEvent;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.consent.InteractionResultSet;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetFilters;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.interactions.DisablingInteractionAdvisor;
import org.apache.isis.core.metamodel.interactions.HidingInteractionAdvisor;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.ValidatingInteractionAdvisor;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;

public final class InteractionUtils {
    private InteractionUtils() {
    }

    public static InteractionResult isVisibleResult(FacetHolder facetHolder, VisibilityContext<?> context) {
        InteractionResult result = new InteractionResult((InteractionEvent)context.createInteractionEvent());
        List<Facet> facets = facetHolder.getFacets(FacetFilters.isA(HidingInteractionAdvisor.class));
        for (Facet facet : facets) {
            HidingInteractionAdvisor advisor = (HidingInteractionAdvisor)facet;
            result.advise(advisor.hides(context), advisor);
        }
        return result;
    }

    public static InteractionResultSet isVisibleResultSet(FacetHolder facetHolder, VisibilityContext<?> context, InteractionResultSet resultSet) {
        return resultSet.add(InteractionUtils.isVisibleResult(facetHolder, context));
    }

    public static InteractionResult isUsableResult(FacetHolder facetHolder, UsabilityContext<?> context) {
        InteractionResult result = new InteractionResult((InteractionEvent)context.createInteractionEvent());
        List<Facet> facets = facetHolder.getFacets(FacetFilters.isA(DisablingInteractionAdvisor.class));
        for (Facet facet : facets) {
            DisablingInteractionAdvisor advisor = (DisablingInteractionAdvisor)facet;
            String disables = advisor.disables(context);
            result.advise(disables, advisor);
        }
        return result;
    }

    public static InteractionResultSet isUsableResultSet(FacetHolder facetHolder, UsabilityContext<?> context, InteractionResultSet resultSet) {
        return resultSet.add(InteractionUtils.isUsableResult(facetHolder, context));
    }

    public static InteractionResult isValidResult(FacetHolder facetHolder, ValidityContext<?> context) {
        InteractionResult result = new InteractionResult((InteractionEvent)context.createInteractionEvent());
        List<Facet> facets = facetHolder.getFacets(FacetFilters.isA(ValidatingInteractionAdvisor.class));
        for (Facet facet : facets) {
            ValidatingInteractionAdvisor advisor = (ValidatingInteractionAdvisor)facet;
            result.advise(advisor.invalidates(context), advisor);
        }
        return result;
    }

    public static InteractionResultSet isValidResultSet(FacetHolder facetHolder, ValidityContext<?> context, InteractionResultSet resultSet) {
        return resultSet.add(InteractionUtils.isValidResult(facetHolder, context));
    }
}

