/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec.feature;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.util.List;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Bulk;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetFilters;
import org.apache.isis.core.metamodel.facets.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.named.NamedFacet;
import org.apache.isis.core.metamodel.interactions.ActionInvocationContext;
import org.apache.isis.core.metamodel.interactions.ValidatingInteractionAdvisor;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.progmodel.facets.actions.bulk.BulkFacet;

public interface ObjectAction
extends ObjectMember {
    public ActionSemantics.Of getSemantics();

    public ObjectSpecification getOnType();

    public boolean promptForParameters(ObjectAdapter var1);

    public ActionType getType();

    public ObjectSpecification getReturnType();

    public boolean hasReturn();

    public ObjectAdapter execute(ObjectAdapter var1, ObjectAdapter[] var2);

    public ActionInvocationContext createActionInvocationInteractionContext(AuthenticationSession var1, InteractionInvocationMethod var2, ObjectAdapter var3, ObjectAdapter[] var4);

    public Consent isProposedArgumentSetValid(ObjectAdapter var1, ObjectAdapter[] var2);

    public int getParameterCount();

    public List<ObjectActionParameter> getParameters();

    public List<ObjectSpecification> getParameterTypes();

    public List<ObjectActionParameter> getParameters(Filter<ObjectActionParameter> var1);

    public ObjectActionParameter getParameterById(String var1);

    public ObjectActionParameter getParameterByName(String var1);

    public ObjectAdapter[] getDefaults(ObjectAdapter var1);

    public ObjectAdapter[][] getChoices(ObjectAdapter var1);

    public static final class Filters {
        @Deprecated
        public static final Filter<ObjectAction> VISIBLE_AT_LEAST_SOMETIMES = new Filter<ObjectAction>(){

            public boolean accept(ObjectAction action) {
                HiddenFacet hiddenFacet = action.getFacet(HiddenFacet.class);
                return hiddenFacet == null || hiddenFacet.when() != When.ALWAYS || hiddenFacet.where() != Where.ANYWHERE;
            }
        };

        private Filters() {
        }

        @Deprecated
        public static Filter<ObjectAction> dynamicallyVisible(final AuthenticationSession session, final ObjectAdapter target, final Where where) {
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction objectAction) {
                    Consent visible = objectAction.isVisible(session, target, where);
                    return visible.isAllowed();
                }
            };
        }

        @Deprecated
        public static Filter<ObjectAction> withId(final String actionId) {
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction objectAction) {
                    return objectAction.getId().equals(actionId);
                }
            };
        }

        @Deprecated
        public static Filter<ObjectAction> withNoValidationRules() {
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction objectAction) {
                    List<Facet> validatingFacets = objectAction.getFacets(FacetFilters.isA(ValidatingInteractionAdvisor.class));
                    return validatingFacets.isEmpty();
                }
            };
        }

        @Deprecated
        public static Filter<ObjectAction> ofType(final ActionType type) {
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction oa) {
                    return oa.getType() == type;
                }
            };
        }

        @Deprecated
        public static Filter<ObjectAction> bulk() {
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction oa) {
                    Class<?> returnType;
                    if (!oa.containsDoOpFacet(BulkFacet.class)) {
                        return false;
                    }
                    if (oa.getParameterCount() != 0) {
                        return false;
                    }
                    ObjectSpecification returnSpec = oa.getReturnType();
                    return returnSpec == null || (returnType = returnSpec.getCorrespondingClass()) != Blob.class && returnType != Clob.class;
                }
            };
        }

        @Deprecated
        public static Filter<ObjectAction> notBulkOnly() {
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction t) {
                    BulkFacet facet = t.getFacet(BulkFacet.class);
                    return facet == null || facet.value() != Bulk.AppliesTo.BULK_ONLY;
                }
            };
        }

        public static Filter<ObjectAction> memberOrderOf(ObjectAssociation association) {
            final String assocName = association.getName();
            final String assocId = association.getId();
            return new Filter<ObjectAction>(){

                public boolean accept(ObjectAction t) {
                    MemberOrderFacet memberOrderFacet = t.getFacet(MemberOrderFacet.class);
                    if (memberOrderFacet == null) {
                        return false;
                    }
                    String memberOrderName = memberOrderFacet.name();
                    if (Strings.isNullOrEmpty((String)memberOrderName)) {
                        return false;
                    }
                    return memberOrderName.equalsIgnoreCase(assocName) || memberOrderName.equalsIgnoreCase(assocId);
                }
            };
        }
    }

    public static final class Predicates {
        public static final Predicate<ObjectAction> VISIBLE_AT_LEAST_SOMETIMES = org.apache.isis.applib.filter.Filters.asPredicate(Filters.VISIBLE_AT_LEAST_SOMETIMES);

        private Predicates() {
        }

        public static Predicate<ObjectAction> dynamicallyVisible(AuthenticationSession session, ObjectAdapter target, Where where) {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.dynamicallyVisible(session, target, where));
        }

        public static Predicate<ObjectAction> withId(String actionId) {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.withId(actionId));
        }

        public static Predicate<ObjectAction> withNoValidationRules() {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.withNoValidationRules());
        }

        public static Predicate<ObjectAction> ofType(ActionType type) {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.ofType(type));
        }

        public static Predicate<ObjectAction> bulk() {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.bulk());
        }

        public static Predicate<ObjectAction> notBulkOnly() {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.notBulkOnly());
        }

        public static Predicate<ObjectAction> memberOrderOf(ObjectAssociation association) {
            return org.apache.isis.applib.filter.Filters.asPredicate(Filters.memberOrderOf(association));
        }
    }

    public static final class Utils {
        private Utils() {
        }

        public static String nameFor(ObjectAction objAction) {
            String actionName = objAction.getName();
            if (actionName != null) {
                return actionName;
            }
            NamedFacet namedFacet = objAction.getFacet(NamedFacet.class);
            if (namedFacet != null) {
                return namedFacet.value();
            }
            return "(no name)";
        }
    }
}

