/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.adapter.ServicesProvider;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecorator;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecoratorSet;
import org.apache.isis.core.metamodel.facets.object.bounded.ChoicesFacetUtils;
import org.apache.isis.core.metamodel.facets.object.objecttype.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContextAware;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.noruntime.RuntimeContextNoRuntime;
import org.apache.isis.core.metamodel.spec.FreeStandingList;
import org.apache.isis.core.metamodel.spec.ObjectInstantiator;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationContext;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderAware;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpiAware;
import org.apache.isis.core.metamodel.spec.feature.ObjectMemberContext;
import org.apache.isis.core.metamodel.specloader.ServiceInitializer;
import org.apache.isis.core.metamodel.specloader.SpecificationCacheDefault;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.apache.isis.core.metamodel.specloader.facetprocessor.FacetProcessor;
import org.apache.isis.core.metamodel.specloader.specimpl.CreateObjectContext;
import org.apache.isis.core.metamodel.specloader.specimpl.FacetedMethodsBuilderContext;
import org.apache.isis.core.metamodel.specloader.specimpl.IntrospectionContext;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectSpecificationAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.core.metamodel.specloader.specimpl.objectlist.ObjectSpecificationForFreeStandingList;
import org.apache.isis.core.metamodel.specloader.traverser.SpecificationTraverser;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectReflectorDefault
implements SpecificationLoaderSpi,
ApplicationScopedComponent,
RuntimeContextAware,
DebuggableWithTitle {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectReflectorDefault.class);
    private final IsisConfiguration configuration;
    private final ClassSubstitutor classSubstitutor;
    private final CollectionTypeRegistry collectionTypeRegistry;
    private final ProgrammingModel programmingModel;
    private final FacetProcessor facetProcessor;
    private final FacetDecoratorSet facetDecoratorSet;
    private RuntimeContext runtimeContext;
    private final SpecificationTraverser specificationTraverser;
    private DomainObjectContainer container;
    private List<Object> services;
    private final MetaModelValidator metaModelValidator;
    private final SpecificationCacheDefault cache = new SpecificationCacheDefault();
    private final ServiceInitializer serviceInitializer = new ServiceInitializer();
    private boolean initialized = false;

    public ObjectReflectorDefault(IsisConfiguration configuration, ClassSubstitutor classSubstitutor, CollectionTypeRegistry collectionTypeRegistry, SpecificationTraverser specificationTraverser, ProgrammingModel programmingModel, Set<FacetDecorator> facetDecorators, MetaModelValidator metaModelValidator) {
        Ensure.ensureThatArg(configuration, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(classSubstitutor, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(collectionTypeRegistry, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(specificationTraverser, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(programmingModel, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(facetDecorators, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(metaModelValidator, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.configuration = configuration;
        this.classSubstitutor = classSubstitutor;
        this.collectionTypeRegistry = collectionTypeRegistry;
        this.programmingModel = programmingModel;
        this.specificationTraverser = specificationTraverser;
        this.facetDecoratorSet = new FacetDecoratorSet();
        for (FacetDecorator facetDecorator : facetDecorators) {
            this.facetDecoratorSet.add(facetDecorator);
        }
        this.metaModelValidator = metaModelValidator;
        this.facetProcessor = new FacetProcessor(configuration, collectionTypeRegistry, programmingModel);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.info("finalizing reflector factory " + this);
    }

    @Override
    public void init() {
        ValidationFailures validationFailures = this.initAndValidate();
        validationFailures.assertNone();
        this.cacheBySpecId();
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public ValidationFailures initAndValidate() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialising " + this);
        }
        if (this.runtimeContext == null) {
            this.runtimeContext = new RuntimeContextNoRuntime();
        }
        this.injectInto(this.runtimeContext);
        this.injectInto(this.specificationTraverser);
        this.injectInto(this.metaModelValidator);
        this.runtimeContext.injectInto(this.facetProcessor);
        this.facetDecoratorSet.init();
        this.classSubstitutor.init();
        this.collectionTypeRegistry.init();
        this.specificationTraverser.init();
        this.programmingModel.init();
        this.facetProcessor.init();
        this.metaModelValidator.init();
        this.primeCache();
        ValidationFailures validationFailures = new ValidationFailures();
        this.metaModelValidator.validate(validationFailures);
        return validationFailures;
    }

    private void cacheBySpecId() {
        HashMap specById = Maps.newHashMap();
        for (ObjectSpecification objSpec : this.allSpecifications()) {
            ObjectSpecId objectSpecId = objSpec.getSpecId();
            if (objectSpecId == null) continue;
            specById.put(objectSpecId, objSpec);
        }
        this.getCache().setCacheBySpecId(specById);
    }

    private void primeCache() {
        for (Class<?> serviceClass : this.getServiceClasses()) {
            this.internalLoadSpecification(serviceClass);
        }
        this.loadAllSpecifications();
    }

    private void loadAllSpecifications() {
        List<Class<?>> newlyDiscoveredClasses = this.newlyDiscoveredClasses();
        while (newlyDiscoveredClasses.size() > 0) {
            for (Class<?> newClass : newlyDiscoveredClasses) {
                this.internalLoadSpecification(newClass);
            }
            newlyDiscoveredClasses = this.newlyDiscoveredClasses();
        }
    }

    private List<Class<?>> newlyDiscoveredClasses() {
        ArrayList newlyDiscoveredClasses = new ArrayList();
        Collection<ObjectSpecification> noSpecs = this.allSpecifications();
        try {
            for (ObjectSpecification noSpec : noSpecs) {
                this.getSpecificationTraverser().traverseReferencedClasses(noSpec, newlyDiscoveredClasses);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new IsisException(ex);
        }
        return newlyDiscoveredClasses;
    }

    @Override
    public void shutdown() {
        LOG.info("shutting down " + this);
        this.initialized = false;
        this.getCache().clear();
        this.facetDecoratorSet.shutdown();
    }

    @Override
    public void invalidateCacheFor(Object domainObject) {
        this.invalidateCache(domainObject.getClass());
    }

    @Override
    public void invalidateCache(Class<?> cls) {
        if (!this.getCache().isInitialized()) {
            return;
        }
        Class<?> substitutedType = this.getClassSubstitutor().getClass(cls);
        if (substitutedType.isAnonymousClass()) {
            return;
        }
        for (ObjectSpecification spec = this.loadSpecification(substitutedType); spec != null; spec = spec.superclass()) {
            Class<?> type = spec.getCorrespondingClass();
            this.getCache().remove(type.getName());
            if (!spec.containsDoOpFacet(ObjectSpecIdFacet.class)) continue;
            this.recache(spec);
        }
    }

    private void recache(ObjectSpecification newSpec) {
        this.getCache().recache(newSpec);
    }

    @Override
    public final ObjectSpecification loadSpecification(String className) {
        Ensure.ensureThatArg(className, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), "specification class name must be specified");
        try {
            Class<?> cls = this.loadBuiltIn(className);
            return this.internalLoadSpecification(cls);
        }
        catch (ClassNotFoundException e) {
            ObjectSpecification spec = this.getCache().get(className);
            if (spec == null) {
                throw new IsisException("No such class available: " + className);
            }
            return spec;
        }
    }

    @Override
    public ObjectSpecification loadSpecification(Class<?> type) {
        ObjectSpecification spec = this.internalLoadSpecification(type);
        if (spec == null) {
            return null;
        }
        if (this.getCache().isInitialized() && spec.containsDoOpFacet(ObjectSpecIdFacet.class)) {
            ObjectSpecId specId = spec.getSpecId();
            if (this.getCache().getByObjectType(specId) == null) {
                this.getCache().recache(spec);
            }
        }
        return spec;
    }

    private ObjectSpecification internalLoadSpecification(Class<?> type) {
        Class<?> substitutedType = this.getClassSubstitutor().getClass(type);
        return substitutedType != null ? this.loadSpecificationForSubstitutedClass(substitutedType) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectSpecification loadSpecificationForSubstitutedClass(Class<?> type) {
        SpecificationCacheDefault specificationCache;
        Assert.assertNotNull(type);
        String typeName = type.getName();
        SpecificationCacheDefault specificationCacheDefault = specificationCache = this.getCache();
        synchronized (specificationCacheDefault) {
            ObjectSpecification spec = specificationCache.get(typeName);
            if (spec != null) {
                return spec;
            }
            ObjectSpecification specification = this.createSpecification(type);
            if (specification == null) {
                throw new IsisException("Failed to create specification for class " + typeName);
            }
            specificationCache.cache(typeName, specification);
            this.introspectIfRequired(specification);
            return specification;
        }
    }

    @Override
    public boolean loadSpecifications(List<Class<?>> typesToLoad, Class<?> typeToIgnore) {
        boolean anyLoadedAsNull = false;
        for (Class<?> typeToLoad : typesToLoad) {
            if (typeToLoad == typeToIgnore) continue;
            ObjectSpecification noSpec = this.internalLoadSpecification(typeToLoad);
            boolean loadedAsNull = noSpec == null;
            anyLoadedAsNull = loadedAsNull || anyLoadedAsNull;
        }
        return anyLoadedAsNull;
    }

    @Override
    public boolean loadSpecifications(List<Class<?>> typesToLoad) {
        return this.loadSpecifications(typesToLoad, null);
    }

    private ObjectSpecification createSpecification(Class<?> cls) {
        AuthenticationSessionProvider authenticationSessionProvider = this.getRuntimeContext().getAuthenticationSessionProvider();
        SpecificationLoader specificationLookup = this.getRuntimeContext().getSpecificationLoader();
        ServicesProvider servicesProvider = this.getRuntimeContext().getServicesProvider();
        ObjectInstantiator objectInstantiator = this.getRuntimeContext().getObjectInstantiator();
        SpecificationContext specContext = new SpecificationContext(this.getDeploymentCategory(), authenticationSessionProvider, servicesProvider, objectInstantiator, specificationLookup, this.facetProcessor);
        AdapterManager adapterMap = this.getRuntimeContext().getAdapterManager();
        ObjectMemberContext objectMemberContext = new ObjectMemberContext(this.getDeploymentCategory(), authenticationSessionProvider, specificationLookup, adapterMap, this.getRuntimeContext().getQuerySubmitter(), this.collectionTypeRegistry, servicesProvider);
        if (FreeStandingList.class.isAssignableFrom(cls)) {
            return new ObjectSpecificationForFreeStandingList(specContext, objectMemberContext);
        }
        ObjectReflectorDefault specificationLoader = this;
        IntrospectionContext introspectionContext = new IntrospectionContext(this.getClassSubstitutor());
        ServicesInjector dependencyInjector = this.getRuntimeContext().getDependencyInjector();
        CreateObjectContext createObjectContext = new CreateObjectContext(adapterMap, dependencyInjector);
        FacetedMethodsBuilderContext facetedMethodsBuilderContext = new FacetedMethodsBuilderContext(specificationLoader, this.classSubstitutor, this.specificationTraverser, this.facetProcessor);
        return new ObjectSpecificationDefault(cls, facetedMethodsBuilderContext, introspectionContext, specContext, objectMemberContext, createObjectContext);
    }

    private DeploymentCategory getDeploymentCategory() {
        if (this.runtimeContext == null) {
            throw new IllegalStateException("Runtime context has not been injected.");
        }
        return this.runtimeContext.getDeploymentCategory();
    }

    private Class<?> loadBuiltIn(String className) throws ClassNotFoundException {
        Class<?> builtIn = ClassUtil.getBuiltIn(className);
        if (builtIn != null) {
            return builtIn;
        }
        return Class.forName(className);
    }

    @Override
    public Collection<ObjectSpecification> allSpecifications() {
        return this.getCache().allSpecifications();
    }

    @Override
    public boolean loaded(Class<?> cls) {
        return this.loaded(cls.getName());
    }

    @Override
    public boolean loaded(String fullyQualifiedClassName) {
        return this.getCache().get(fullyQualifiedClassName) != null;
    }

    @Override
    public ObjectSpecification introspectIfRequired(ObjectSpecification spec) {
        ObjectSpecificationAbstract specSpi = (ObjectSpecificationAbstract)spec;
        ObjectSpecificationAbstract.IntrospectionState introspectionState = specSpi.getIntrospectionState();
        if (introspectionState == ObjectSpecificationAbstract.IntrospectionState.NOT_INTROSPECTED) {
            specSpi.setIntrospectionState(ObjectSpecificationAbstract.IntrospectionState.BEING_INTROSPECTED);
            specSpi.introspectTypeHierarchyAndMembers();
            this.facetDecoratorSet.decorate(spec);
            specSpi.updateFromFacetValues();
            specSpi.setIntrospectionState(ObjectSpecificationAbstract.IntrospectionState.INTROSPECTED);
        } else if (introspectionState == ObjectSpecificationAbstract.IntrospectionState.BEING_INTROSPECTED) {
            specSpi.introspectTypeHierarchyAndMembers();
            this.facetDecoratorSet.decorate(spec);
            specSpi.updateFromFacetValues();
            specSpi.setIntrospectionState(ObjectSpecificationAbstract.IntrospectionState.INTROSPECTED);
        } else if (introspectionState == ObjectSpecificationAbstract.IntrospectionState.INTROSPECTED) {
            // empty if block
        }
        return spec;
    }

    @Override
    public ObjectSpecification lookupBySpecId(ObjectSpecId objectSpecId) {
        return this.getCache().getByObjectType(objectSpecId);
    }

    @Override
    public void injectInto(Object candidate) {
        Object cast;
        Class<?> candidateClass = candidate.getClass();
        if (SpecificationLoaderSpiAware.class.isAssignableFrom(candidateClass)) {
            cast = (SpecificationLoaderSpiAware)SpecificationLoaderSpiAware.class.cast(candidate);
            cast.setSpecificationLoaderSpi(this);
        }
        if (SpecificationLoaderAware.class.isAssignableFrom(candidateClass)) {
            cast = (SpecificationLoaderAware)SpecificationLoaderAware.class.cast(candidate);
            cast.setSpecificationLookup(this);
        }
        this.getClassSubstitutor().injectInto(candidate);
        this.getCollectionTypeRegistry().injectInto(candidate);
    }

    @Override
    public void debugData(DebugBuilder debug) {
        this.facetDecoratorSet.debugData(debug);
        debug.appendln();
        debug.appendTitle("Specifications");
        ArrayList specs = Lists.newArrayList(this.allSpecifications());
        Collections.sort(specs, ObjectSpecification.COMPARATOR_SHORT_IDENTIFIER_IGNORE_CASE);
        for (ObjectSpecification spec : specs) {
            StringBuffer str = new StringBuffer();
            str.append(spec.isAbstract() ? "A" : ".");
            str.append(spec.isService() ? "S" : ".");
            str.append(ChoicesFacetUtils.hasChoices(spec) ? "B" : ".");
            str.append(spec.isParentedOrFreeCollection() ? "C" : ".");
            str.append(spec.isNotCollection() ? "O" : ".");
            str.append(spec.isParseable() ? "P" : ".");
            str.append(spec.isEncodeable() ? "E" : ".");
            str.append(spec.isValueOrIsParented() ? "A" : ".");
            boolean hasIdentity = !spec.isParentedOrFreeCollection() && !spec.isParented() && !spec.isValue();
            str.append(hasIdentity ? "I" : ".");
            str.append("  ");
            str.append(spec.getFullIdentifier());
            debug.appendPreformatted(spec.getShortIdentifier(), str.toString());
        }
    }

    @Override
    public String debugTitle() {
        return "Reflector";
    }

    public FacetProcessor getFacetProcessor() {
        return this.facetProcessor;
    }

    private SpecificationCacheDefault getCache() {
        return this.cache;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    @Override
    public List<Class<?>> getServiceClasses() {
        List serviceClasses = Lists.transform(this.services, (Function)new Function<Object, Class<?>>(){

            public Class<?> apply(Object o) {
                return o.getClass();
            }
        });
        return Collections.unmodifiableList(serviceClasses);
    }

    private List<Object> getServices() {
        return this.services;
    }

    @Override
    public void setContainer(DomainObjectContainer container) {
        this.container = container;
    }

    @Override
    public void setServices(List<Object> services) {
        this.services = services;
    }

    protected IsisConfiguration getIsisConfiguration() {
        return this.configuration;
    }

    protected CollectionTypeRegistry getCollectionTypeRegistry() {
        return this.collectionTypeRegistry;
    }

    protected ClassSubstitutor getClassSubstitutor() {
        return this.classSubstitutor;
    }

    protected SpecificationTraverser getSpecificationTraverser() {
        return this.specificationTraverser;
    }

    protected ProgrammingModel getProgrammingModelFacets() {
        return this.programmingModel;
    }

    protected MetaModelValidator getMetaModelValidator() {
        return this.metaModelValidator;
    }

    protected Set<FacetDecorator> getFacetDecoratorSet() {
        return this.facetDecoratorSet.getFacetDecorators();
    }

    @Override
    public void validateSpecifications(ValidationFailures validationFailures) {
        HashMap specById = Maps.newHashMap();
        for (ObjectSpecification objSpec : this.allSpecifications()) {
            ObjectSpecification existingSpec;
            ObjectSpecId objectSpecId = objSpec.getSpecId();
            if (objectSpecId == null || (existingSpec = specById.put(objectSpecId, objSpec)) == null) continue;
            validationFailures.add("Cannot have two entities with same object type (@ObjectType facet or equivalent) Value; both %s and %s are annotated with value of ''%s''.", existingSpec.getFullIdentifier(), objSpec.getFullIdentifier(), objectSpecId);
        }
    }
}

