/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.isis.core.metamodel.facets.object.objecttype.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

class SpecificationCacheDefault {
    private final Map<String, ObjectSpecification> specByClassName = Maps.newHashMap();
    private Map<ObjectSpecId, ObjectSpecification> specById;

    SpecificationCacheDefault() {
    }

    public ObjectSpecification get(String className) {
        return this.specByClassName.get(className);
    }

    public void cache(String className, ObjectSpecification spec) {
        this.specByClassName.put(className, spec);
    }

    public void clear() {
        this.specByClassName.clear();
    }

    public Collection<ObjectSpecification> allSpecifications() {
        return Collections.unmodifiableCollection(this.specByClassName.values());
    }

    public ObjectSpecification getByObjectType(ObjectSpecId objectSpecID) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("SpecificationCache by object type has not yet been initialized");
        }
        return this.specById.get(objectSpecID);
    }

    void setCacheBySpecId(Map<ObjectSpecId, ObjectSpecification> specById) {
        this.specById = Maps.newHashMap();
        this.specById.putAll(specById);
    }

    public ObjectSpecification remove(String typeName) {
        ObjectSpecification removed = this.specByClassName.remove(typeName);
        if (removed != null && removed.containsDoOpFacet(ObjectSpecIdFacet.class)) {
            ObjectSpecId specId = removed.getSpecId();
            this.specById.remove(specId);
        }
        return removed;
    }

    public void recache(ObjectSpecification spec) {
        if (!this.isInitialized()) {
            return;
        }
        this.specById.put(spec.getSpecId(), spec);
    }

    boolean isInitialized() {
        return this.specById != null;
    }
}

