/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.NotPersistable;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.exceptions.UnknownTypeException;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ServicesProvider;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetHolderImpl;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.help.HelpFacet;
import org.apache.isis.core.metamodel.facets.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.object.aggregated.ParentedFacet;
import org.apache.isis.core.metamodel.facets.object.dirty.ClearDirtyObjectFacet;
import org.apache.isis.core.metamodel.facets.object.dirty.IsDirtyObjectFacet;
import org.apache.isis.core.metamodel.facets.object.dirty.MarkDirtyObjectFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.object.icon.IconFacet;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacet;
import org.apache.isis.core.metamodel.facets.object.membergroups.MemberGroupLayoutFacet;
import org.apache.isis.core.metamodel.facets.object.notpersistable.NotPersistableFacet;
import org.apache.isis.core.metamodel.facets.object.objecttype.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.facets.object.plural.PluralFacet;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.ObjectTitleContext;
import org.apache.isis.core.metamodel.interactions.ObjectValidityContext;
import org.apache.isis.core.metamodel.layout.DeweyOrderSet;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.Instance;
import org.apache.isis.core.metamodel.spec.ObjectInstantiator;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.ObjectSpecificationException;
import org.apache.isis.core.metamodel.spec.Persistability;
import org.apache.isis.core.metamodel.spec.SpecificationContext;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMemberContext;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.facetprocessor.FacetProcessor;
import org.apache.isis.core.metamodel.specloader.specimpl.ContributeeMember;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionImpl;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectAssociationAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToManyAssociationContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneAssociationContributee;
import org.apache.isis.core.progmodel.facets.actions.notcontributed.NotContributedFacet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectSpecificationAbstract
extends FacetHolderImpl
implements ObjectSpecification {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectSpecificationAbstract.class);
    private final DeploymentCategory deploymentCategory;
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final ServicesProvider servicesProvider;
    private final ObjectInstantiator objectInstantiator;
    private final SpecificationLoader specificationLookup;
    private final FacetProcessor facetProcessor;
    protected Properties metadataProperties;
    protected final ObjectMemberContext objectMemberContext;
    private final List<ObjectAssociation> associations = Lists.newArrayList();
    private final List<ObjectAction> objectActions = Lists.newArrayList();
    private final Map<ActionType, List<ObjectAction>> objectActionsByType = ObjectSpecificationAbstract.createObjectActionsByType();
    private boolean contributeeAssociationsAdded;
    private boolean contributeeActionsAdded;
    private final List<ObjectSpecification> interfaces = Lists.newArrayList();
    private final SubclassList subclasses = new SubclassList();
    private final Class<?> correspondingClass;
    private final String fullName;
    private final String shortName;
    private final Identifier identifier;
    private final boolean isAbstract;
    private ObjectSpecId specId;
    private ObjectSpecification superclassSpec;
    private Persistability persistability = Persistability.USER_PERSISTABLE;
    private MarkDirtyObjectFacet markDirtyObjectFacet;
    private ClearDirtyObjectFacet clearDirtyObjectFacet;
    private IsDirtyObjectFacet isDirtyObjectFacet;
    private TitleFacet titleFacet;
    private IconFacet iconFacet;
    private IntrospectionState introspected = IntrospectionState.NOT_INTROSPECTED;
    private static ThreadLocal<Boolean> invalidatingCache = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    private static Map<ActionType, List<ObjectAction>> createObjectActionsByType() {
        HashMap map = Maps.newHashMap();
        for (ActionType type : ActionType.values()) {
            map.put(type, Lists.newArrayList());
        }
        return map;
    }

    public ObjectSpecificationAbstract(Class<?> introspectedClass, String shortName, SpecificationContext specificationContext, ObjectMemberContext objectMemberContext) {
        this.correspondingClass = introspectedClass;
        this.fullName = introspectedClass.getName();
        this.shortName = shortName;
        this.isAbstract = ClassExtensions.isAbstract(introspectedClass);
        this.identifier = Identifier.classIdentifier(introspectedClass);
        this.deploymentCategory = specificationContext.getDeploymentCategory();
        this.authenticationSessionProvider = specificationContext.getAuthenticationSessionProvider();
        this.servicesProvider = specificationContext.getServicesProvider();
        this.objectInstantiator = specificationContext.getObjectInstantiator();
        this.specificationLookup = specificationContext.getSpecificationLookup();
        this.facetProcessor = specificationContext.getFacetProcessor();
        this.objectMemberContext = objectMemberContext;
    }

    protected DeploymentCategory getDeploymentCategory() {
        return this.deploymentCategory;
    }

    @Override
    public FeatureType getFeatureType() {
        return FeatureType.OBJECT;
    }

    @Override
    public ObjectSpecId getSpecId() {
        if (this.specId == null) {
            ObjectSpecIdFacet facet = this.getFacet((Class)ObjectSpecIdFacet.class);
            if (facet == null) {
                throw new IllegalStateException("could not find an ObjectSpecIdFacet for " + this.getFullIdentifier());
            }
            if (facet != null) {
                this.specId = facet.value();
            }
        }
        return this.specId;
    }

    @Override
    public Class<?> getCorrespondingClass() {
        return this.correspondingClass;
    }

    @Override
    public String getShortIdentifier() {
        return this.shortName;
    }

    @Override
    public String getFullIdentifier() {
        return this.fullName;
    }

    public IntrospectionState getIntrospectionState() {
        return this.introspected;
    }

    public void setIntrospectionState(IntrospectionState introspectationState) {
        this.introspected = introspectationState;
    }

    protected boolean isNotIntrospected() {
        return this.getIntrospectionState() != IntrospectionState.INTROSPECTED;
    }

    public abstract void introspectTypeHierarchyAndMembers();

    protected void updateSuperclass(Class<?> superclass) {
        if (superclass == null) {
            return;
        }
        this.superclassSpec = this.getSpecificationLookup().loadSpecification(superclass);
        if (this.superclassSpec != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Superclass " + superclass.getName());
            }
            this.updateAsSubclassTo(this.superclassSpec);
        }
    }

    protected void updateInterfaces(List<ObjectSpecification> interfaces) {
        this.interfaces.clear();
        this.interfaces.addAll(interfaces);
    }

    protected void updateAsSubclassTo(ObjectSpecification supertypeSpec) {
        if (!(supertypeSpec instanceof ObjectSpecificationAbstract)) {
            return;
        }
        ObjectSpecificationAbstract introspectableSpec = (ObjectSpecificationAbstract)supertypeSpec;
        introspectableSpec.updateSubclasses(this);
    }

    protected void updateAsSubclassTo(List<ObjectSpecification> supertypeSpecs) {
        for (ObjectSpecification supertypeSpec : supertypeSpecs) {
            this.updateAsSubclassTo(supertypeSpec);
        }
    }

    private void updateSubclasses(ObjectSpecification subclass) {
        this.subclasses.addSubclass(subclass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortAndUpdateAssociations(List<ObjectAssociation> associations) {
        List<ObjectAssociation> orderedAssociations = this.sortAssociations(associations);
        List<ObjectAssociation> list = this.associations;
        synchronized (list) {
            this.associations.clear();
            this.associations.addAll(orderedAssociations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortCacheAndUpdateActions(List<ObjectAction> objectActions) {
        List<ObjectAction> orderedActions = ObjectSpecificationAbstract.sortActions(objectActions);
        List<ObjectAction> list = this.objectActions;
        synchronized (list) {
            this.objectActions.clear();
            this.objectActions.addAll(orderedActions);
            for (ActionType type : ActionType.values()) {
                List<ObjectAction> objectActionForType = this.objectActionsByType.get((Object)type);
                objectActionForType.clear();
                objectActionForType.addAll(Collections2.filter(objectActions, ObjectAction.Predicates.ofType(type)));
            }
        }
    }

    public void updateFromFacetValues() {
        this.clearDirtyObjectFacet = this.getFacet((Class)ClearDirtyObjectFacet.class);
        this.markDirtyObjectFacet = this.getFacet((Class)MarkDirtyObjectFacet.class);
        this.isDirtyObjectFacet = this.getFacet((Class)IsDirtyObjectFacet.class);
        this.titleFacet = this.getFacet((Class)TitleFacet.class);
        this.iconFacet = this.getFacet((Class)IconFacet.class);
        this.persistability = this.determinePersistability();
    }

    private Persistability determinePersistability() {
        NotPersistableFacet notPersistableFacet = this.getFacet((Class)NotPersistableFacet.class);
        if (notPersistableFacet == null) {
            return Persistability.USER_PERSISTABLE;
        }
        NotPersistable.By initiatedBy = (NotPersistable.By)notPersistableFacet.value();
        if (initiatedBy == NotPersistable.By.USER_OR_PROGRAM) {
            return Persistability.TRANSIENT;
        }
        if (initiatedBy == NotPersistable.By.USER) {
            return Persistability.PROGRAM_PERSISTABLE;
        }
        return Persistability.USER_PERSISTABLE;
    }

    protected void setClearDirtyObjectFacet(ClearDirtyObjectFacet clearDirtyObjectFacet) {
        this.clearDirtyObjectFacet = clearDirtyObjectFacet;
    }

    @Override
    public String getTitle(ObjectAdapter targetAdapter, Localization localization) {
        return this.getTitle(null, targetAdapter, localization);
    }

    @Override
    public String getTitle(ObjectAdapter contextAdapterIfAny, ObjectAdapter targetAdapter, Localization localization) {
        String titleString;
        if (this.titleFacet != null && (titleString = this.titleFacet.title(contextAdapterIfAny, targetAdapter, localization)) != null && !titleString.equals("")) {
            return titleString;
        }
        return (this.isService() ? "" : "Untitled ") + this.getSingularName();
    }

    @Override
    public String getIconName(ObjectAdapter reference) {
        return this.iconFacet == null ? null : this.iconFacet.iconName(reference);
    }

    @Override
    public Instance getInstance(ObjectAdapter adapter) {
        return adapter;
    }

    @Override
    public boolean isOfType(ObjectSpecification specification) {
        if (specification.getSpecId().equals(this.getSpecId())) {
            return true;
        }
        for (ObjectSpecification interfaceSpec : this.interfaces()) {
            if (!interfaceSpec.isOfType(specification)) continue;
            return true;
        }
        ObjectSpecification superclassSpec = this.superclass();
        return superclassSpec != null ? superclassSpec.isOfType(specification) : false;
    }

    @Override
    public String getSingularName() {
        NamedFacet namedFacet = this.getFacet((Class)NamedFacet.class);
        return namedFacet != null ? namedFacet.value() : this.getFullIdentifier();
    }

    @Override
    public String getPluralName() {
        PluralFacet pluralFacet = this.getFacet((Class)PluralFacet.class);
        return pluralFacet.value();
    }

    @Override
    public String getDescription() {
        DescribedAsFacet describedAsFacet = this.getFacet((Class)DescribedAsFacet.class);
        String describedAs = describedAsFacet.value();
        return describedAs == null ? "" : describedAs;
    }

    @Override
    public String getHelp() {
        HelpFacet helpFacet = this.getFacet((Class)HelpFacet.class);
        return helpFacet == null ? null : helpFacet.value();
    }

    @Override
    public String getCssClass() {
        CssClassFacet cssClassFacet = this.getFacet((Class)CssClassFacet.class);
        return cssClassFacet == null ? null : cssClassFacet.value();
    }

    @Override
    public Persistability persistability() {
        return this.persistability;
    }

    @Override
    public boolean isDirty(ObjectAdapter object) {
        return this.isDirtyObjectFacet == null ? false : this.isDirtyObjectFacet.invoke(object);
    }

    @Override
    public void clearDirty(ObjectAdapter object) {
        if (this.clearDirtyObjectFacet != null) {
            this.clearDirtyObjectFacet.invoke(object);
        }
    }

    @Override
    public void markDirty(ObjectAdapter object) {
        if (this.markDirtyObjectFacet != null) {
            this.markDirtyObjectFacet.invoke(object);
        }
    }

    public <Q extends Facet> Q getFacet(Class<Q> facetType) {
        Q superClassFacet;
        ObjectSpecification superSpec;
        Q facet = super.getFacet(facetType);
        Q noopFacet = null;
        if (this.isNotANoopFacet((Facet)facet)) {
            return facet;
        }
        noopFacet = facet;
        if (this.interfaces() != null) {
            List<ObjectSpecification> interfaces = this.interfaces();
            for (int i = 0; i < interfaces.size(); ++i) {
                ObjectSpecification interfaceSpec = interfaces.get(i);
                if (interfaceSpec == null) continue;
                Q interfaceFacet = interfaceSpec.getFacet(facetType);
                if (this.isNotANoopFacet((Facet)interfaceFacet)) {
                    return interfaceFacet;
                }
                if (noopFacet != null) continue;
                noopFacet = interfaceFacet;
            }
        }
        if ((superSpec = this.superclass()) != null && this.isNotANoopFacet((Facet)(superClassFacet = superSpec.getFacet(facetType)))) {
            return superClassFacet;
        }
        return noopFacet;
    }

    private boolean isNotANoopFacet(Facet facet) {
        return facet != null && !facet.isNoop();
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public ObjectTitleContext createTitleInteractionContext(AuthenticationSession session, InteractionInvocationMethod interactionMethod, ObjectAdapter targetObjectAdapter) {
        return new ObjectTitleContext(this.getDeploymentCategory(), session, interactionMethod, targetObjectAdapter, this.getIdentifier(), targetObjectAdapter.titleString());
    }

    @Override
    public ObjectSpecification superclass() {
        return this.superclassSpec;
    }

    @Override
    public List<ObjectSpecification> interfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    @Override
    public List<ObjectSpecification> subclasses() {
        return this.subclasses.toList();
    }

    @Override
    public boolean hasSubclasses() {
        return this.subclasses.hasSubclasses();
    }

    @Override
    public final boolean isAbstract() {
        return this.isAbstract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectAssociation> getAssociations(Contributed contributed) {
        if (contributed.isIncluded() && !this.contributeeAssociationsAdded) {
            List<ObjectAssociation> list = this.associations;
            synchronized (list) {
                ArrayList associations = Lists.newArrayList(this.associations);
                associations.addAll(this.createContributeeAssociations());
                this.sortAndUpdateAssociations(associations);
                this.contributeeAssociationsAdded = true;
            }
        }
        ArrayList associations = Lists.newArrayList(this.associations);
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)associations, ContributeeMember.Predicates.regularElse(contributed)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectAssociation getAssociation(String id) {
        ObjectAssociation oa = this.getAssociationWithId(id);
        if (oa != null) {
            return oa;
        }
        if (!this.getDeploymentCategory().isProduction()) {
            LOG.warn("Could not find association with id '" + id + "'; invalidating cache automatically");
            if (!invalidatingCache.get().booleanValue()) {
                try {
                    invalidatingCache.set(true);
                    this.getSpecificationLookup().invalidateCache(this.getCorrespondingClass());
                }
                finally {
                    invalidatingCache.set(false);
                }
            } else {
                LOG.warn("... already invalidating cache earlier in stacktrace, so skipped this time");
            }
            oa = this.getAssociationWithId(id);
            if (oa != null) {
                return oa;
            }
        }
        throw new ObjectSpecificationException("No association called '" + id + "' in '" + this.getSingularName() + "'");
    }

    private ObjectAssociation getAssociationWithId(String id) {
        for (ObjectAssociation objectAssociation : this.getAssociations(Contributed.INCLUDED)) {
            if (!objectAssociation.getId().equals(id)) continue;
            return objectAssociation;
        }
        return null;
    }

    @Override
    @Deprecated
    public List<ObjectAssociation> getAssociations(Filter<ObjectAssociation> filter) {
        return this.getAssociations(Contributed.INCLUDED, filter);
    }

    @Override
    public List<ObjectAssociation> getAssociations(Contributed contributed, Filter<ObjectAssociation> filter) {
        List<ObjectAssociation> allAssociations = this.getAssociations(contributed);
        return Lists.newArrayList((Iterable)Iterables.filter(allAssociations, (Predicate)Filters.asPredicate(filter)));
    }

    @Override
    public List<OneToOneAssociation> getProperties(Contributed contributed) {
        List<ObjectAssociation> list = this.getAssociations(contributed, ObjectAssociation.Filters.PROPERTIES);
        return list;
    }

    @Override
    public List<OneToManyAssociation> getCollections(Contributed contributed) {
        List<ObjectAssociation> list = this.getAssociations(contributed, ObjectAssociation.Filters.COLLECTIONS);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectAction> getObjectActions(List<ActionType> types, Contributed contributed, Filter<ObjectAction> filter) {
        if (contributed.isIncluded() && !this.contributeeActionsAdded) {
            List<ObjectAction> list = this.objectActions;
            synchronized (list) {
                ArrayList actions = Lists.newArrayList(this.objectActions);
                actions.addAll(this.createContributeeActions());
                this.sortCacheAndUpdateActions(actions);
                this.contributeeActionsAdded = true;
            }
        }
        ArrayList actions = Lists.newArrayList();
        for (ActionType type : types) {
            Collection filterActions = Collections2.filter((Collection)this.objectActionsByType.get((Object)type), (Predicate)Filters.asPredicate(filter));
            actions.addAll(filterActions);
        }
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)actions, ContributeeMember.Predicates.regularElse(contributed)));
    }

    @Override
    public List<ObjectAction> getObjectActions(Contributed contributed) {
        return this.getObjectActions(ActionType.ALL, contributed, (Filter<ObjectAction>)Filters.any());
    }

    @Override
    public List<ObjectAction> getObjectActions(ActionType type, Contributed contributed, Filter<ObjectAction> filter) {
        return this.getObjectActions(Collections.singletonList(type), contributed, filter);
    }

    protected List<ObjectAssociation> sortAssociations(List<ObjectAssociation> associations) {
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet(associations);
        MemberGroupLayoutFacet memberGroupLayoutFacet = this.getFacet((Class)MemberGroupLayoutFacet.class);
        if (memberGroupLayoutFacet != null) {
            ArrayList groupOrder = Lists.newArrayList();
            groupOrder.addAll(memberGroupLayoutFacet.getLeft());
            groupOrder.addAll(memberGroupLayoutFacet.getMiddle());
            groupOrder.addAll(memberGroupLayoutFacet.getRight());
            orderSet.reorderChildren(groupOrder);
        }
        ArrayList orderedAssociations = Lists.newArrayList();
        ObjectSpecificationAbstract.sortAssociations(orderSet, orderedAssociations);
        return orderedAssociations;
    }

    private static void sortAssociations(DeweyOrderSet orderSet, List<ObjectAssociation> associationsToAppendTo) {
        for (Object element : orderSet) {
            if (element instanceof OneToManyAssociation) {
                associationsToAppendTo.add((ObjectAssociation)element);
                continue;
            }
            if (element instanceof OneToOneAssociation) {
                associationsToAppendTo.add((ObjectAssociation)element);
                continue;
            }
            if (element instanceof DeweyOrderSet) {
                DeweyOrderSet childOrderSet = (DeweyOrderSet)element;
                ObjectSpecificationAbstract.sortAssociations(childOrderSet, associationsToAppendTo);
                continue;
            }
            throw new UnknownTypeException(element);
        }
    }

    protected static List<ObjectAction> sortActions(List<ObjectAction> actions) {
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet(actions);
        ArrayList orderedActions = Lists.newArrayList();
        ObjectSpecificationAbstract.sortActions(orderSet, orderedActions);
        return orderedActions;
    }

    private static void sortActions(DeweyOrderSet orderSet, List<ObjectAction> actionsToAppendTo) {
        for (Object element : orderSet) {
            if (element instanceof ObjectAction) {
                ObjectAction objectAction = (ObjectAction)element;
                actionsToAppendTo.add(objectAction);
                continue;
            }
            if (element instanceof DeweyOrderSet) {
                DeweyOrderSet set = (DeweyOrderSet)element;
                ArrayList actions = Lists.newArrayList();
                ObjectSpecificationAbstract.sortActions(set, actions);
                actionsToAppendTo.addAll(actions);
                continue;
            }
            throw new UnknownTypeException(element);
        }
    }

    @Override
    public List<ObjectAction> getServiceActionsReturning(List<ActionType> types) {
        ArrayList serviceActions = Lists.newArrayList();
        List<ObjectAdapter> services = this.getServicesProvider().getServices();
        for (ObjectAdapter serviceAdapter : services) {
            this.appendServiceActionsReturning(serviceAdapter, types, serviceActions);
        }
        return serviceActions;
    }

    private void appendServiceActionsReturning(ObjectAdapter serviceAdapter, List<ActionType> types, List<ObjectAction> relatedActionsToAppendTo) {
        ArrayList matchingActionsToAppendTo = Lists.newArrayList();
        for (ActionType type : types) {
            List<ObjectAction> serviceActions = serviceAdapter.getSpecification().getObjectActions(type, Contributed.INCLUDED, (Filter<ObjectAction>)Filters.any());
            for (ObjectAction serviceAction : serviceActions) {
                this.addIfReturnsSubtype(serviceAction, matchingActionsToAppendTo);
            }
        }
        relatedActionsToAppendTo.addAll(matchingActionsToAppendTo);
    }

    private void addIfReturnsSubtype(ObjectAction serviceAction, List<ObjectAction> matchingActionsToAppendTo) {
        ObjectSpecification returnType = serviceAction.getReturnType();
        if (returnType == null) {
            return;
        }
        if (returnType.isParentedOrFreeCollection()) {
            TypeOfFacet facet = serviceAction.getFacet(TypeOfFacet.class);
            if (facet != null) {
                ObjectSpecification elementType = facet.valueSpec();
                this.addIfReturnsSubtype(serviceAction, elementType, matchingActionsToAppendTo);
            }
        } else {
            this.addIfReturnsSubtype(serviceAction, returnType, matchingActionsToAppendTo);
        }
    }

    private void addIfReturnsSubtype(ObjectAction serviceAction, ObjectSpecification actionType, List<ObjectAction> matchingActionsToAppendTo) {
        if (actionType.isOfType(this)) {
            matchingActionsToAppendTo.add(serviceAction);
        }
    }

    private List<ObjectAssociation> createContributeeAssociations() {
        if (this.isService()) {
            return Collections.emptyList();
        }
        ArrayList contributeeAssociations = Lists.newArrayList();
        List<ObjectAdapter> services = this.getServicesProvider().getServices();
        for (ObjectAdapter serviceAdapter : services) {
            this.addContributeeAssociationsIfAny(serviceAdapter, contributeeAssociations);
        }
        return contributeeAssociations;
    }

    private void addContributeeAssociationsIfAny(ObjectAdapter serviceAdapter, List<ObjectAssociation> contributeeAssociationsToAppendTo) {
        ObjectSpecification specification = serviceAdapter.getSpecification();
        if (specification == this) {
            return;
        }
        List<ObjectAssociation> contributeeAssociations = this.createContributeeAssociations(serviceAdapter);
        contributeeAssociationsToAppendTo.addAll(contributeeAssociations);
    }

    private List<ObjectAssociation> createContributeeAssociations(ObjectAdapter serviceAdapter) {
        ObjectSpecification specification = serviceAdapter.getSpecification();
        List<ObjectAction> serviceActions = specification.getObjectActions(ActionType.USER, Contributed.INCLUDED, (Filter<ObjectAction>)Filters.any());
        ArrayList contributedActions = Lists.newArrayList();
        for (ObjectAction serviceAction : serviceActions) {
            NotContributedFacet notContributed;
            if (this.isAlwaysHidden(serviceAction) || (notContributed = serviceAction.getFacet(NotContributedFacet.class)) != null && notContributed.toAssociations() || !serviceAction.hasReturn() || serviceAction.getParameterCount() != 1 || this.contributeeParameterMatchOf(serviceAction) == -1 || !(serviceAction instanceof ObjectActionImpl)) continue;
            contributedActions.add((ObjectActionImpl)serviceAction);
        }
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)contributedActions, this.createContributeeAssociationFunctor(serviceAdapter, this)));
    }

    private Function<ObjectActionImpl, ObjectAssociation> createContributeeAssociationFunctor(final ObjectAdapter serviceAdapter, final ObjectSpecification contributeeType) {
        return new Function<ObjectActionImpl, ObjectAssociation>(){

            public ObjectAssociation apply(ObjectActionImpl input) {
                ObjectSpecification returnType = input.getReturnType();
                ObjectAssociationAbstract association = returnType.isNotCollection() ? new OneToOneAssociationContributee(serviceAdapter, input, contributeeType, ObjectSpecificationAbstract.this.objectMemberContext) : new OneToManyAssociationContributee(serviceAdapter, input, contributeeType, ObjectSpecificationAbstract.this.objectMemberContext);
                ObjectSpecificationAbstract.this.facetProcessor.processMemberOrder(ObjectSpecificationAbstract.this.metadataProperties, association);
                return association;
            }
        };
    }

    protected List<ObjectAction> createContributeeActions() {
        if (this.isService()) {
            return Collections.emptyList();
        }
        ArrayList contributeeActions = Lists.newArrayList();
        List<ObjectAdapter> services = this.getServicesProvider().getServices();
        for (ObjectAdapter serviceAdapter : services) {
            this.addContributeeActionsIfAny(serviceAdapter, contributeeActions);
        }
        return contributeeActions;
    }

    private void addContributeeActionsIfAny(ObjectAdapter serviceAdapter, List<ObjectAction> contributeeActionsToAppendTo) {
        ObjectSpecification specification = serviceAdapter.getSpecification();
        if (specification == this) {
            return;
        }
        ArrayList contributeeActions = Lists.newArrayList();
        List<ObjectAction> serviceActions = specification.getObjectActions(ActionType.ALL, Contributed.INCLUDED, (Filter<ObjectAction>)Filters.any());
        for (ObjectAction serviceAction : serviceActions) {
            ObjectActionImpl contributedAction;
            int contributeeParam;
            NotContributedFacet notContributed;
            if (this.isAlwaysHidden(serviceAction) || (notContributed = serviceAction.getFacet(NotContributedFacet.class)) != null && notContributed.toActions() || !(serviceAction instanceof ObjectActionImpl) || (contributeeParam = this.contributeeParameterMatchOf(contributedAction = (ObjectActionImpl)serviceAction)) == -1) continue;
            ObjectActionContributee contributeeAction = new ObjectActionContributee(serviceAdapter, contributedAction, contributeeParam, this, this.objectMemberContext);
            this.facetProcessor.processMemberOrder(this.metadataProperties, contributeeAction);
            contributeeActions.add(contributeeAction);
        }
        contributeeActionsToAppendTo.addAll(contributeeActions);
    }

    private boolean isAlwaysHidden(FacetHolder holder) {
        HiddenFacet hiddenFacet = holder.getFacet(HiddenFacet.class);
        return hiddenFacet != null && hiddenFacet.when() == When.ALWAYS && hiddenFacet.where() == Where.ANYWHERE;
    }

    private int contributeeParameterMatchOf(ObjectAction serviceAction) {
        List<ObjectActionParameter> params = serviceAction.getParameters();
        for (ObjectActionParameter param : params) {
            if (!this.isOfType(param.getSpecification())) continue;
            return param.getNumber();
        }
        return -1;
    }

    @Override
    public Consent isValid(ObjectAdapter inObject) {
        return this.isValidResult(inObject).createConsent();
    }

    @Override
    public InteractionResult isValidResult(ObjectAdapter targetObjectAdapter) {
        ObjectValidityContext validityContext = this.createValidityInteractionContext(this.deploymentCategory, this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, targetObjectAdapter);
        return InteractionUtils.isValidResult(this, validityContext);
    }

    @Override
    public ObjectValidityContext createValidityInteractionContext(DeploymentCategory deploymentCategory, AuthenticationSession session, InteractionInvocationMethod interactionMethod, ObjectAdapter targetObjectAdapter) {
        return new ObjectValidityContext(deploymentCategory, session, interactionMethod, targetObjectAdapter, this.getIdentifier());
    }

    @Override
    public boolean isImmutable() {
        return this.containsFacet(ImmutableFacet.class);
    }

    @Override
    public boolean isHidden() {
        return this.containsFacet(HiddenFacet.class);
    }

    @Override
    public boolean isParseable() {
        return this.containsFacet(ParseableFacet.class);
    }

    @Override
    public boolean isEncodeable() {
        return this.containsFacet(EncodableFacet.class);
    }

    @Override
    public boolean isValue() {
        return this.containsFacet(ValueFacet.class);
    }

    @Override
    public boolean isParented() {
        return this.containsFacet(ParentedFacet.class);
    }

    @Override
    public boolean isParentedOrFreeCollection() {
        return this.containsFacet(CollectionFacet.class);
    }

    @Override
    public boolean isNotCollection() {
        return !this.isParentedOrFreeCollection();
    }

    @Override
    public boolean isValueOrIsParented() {
        return this.isValue() || this.isParented();
    }

    @Override
    public Object createObject() {
        throw new UnsupportedOperationException(this.getFullIdentifier());
    }

    @Override
    public ObjectAdapter initialize(ObjectAdapter objectAdapter) {
        return objectAdapter;
    }

    public String toString() {
        ToString str = new ToString(this);
        str.append("class", this.getFullIdentifier());
        return str.toString();
    }

    protected final AuthenticationSession getAuthenticationSession() {
        return this.getAuthenticationSessionProvider().getAuthenticationSession();
    }

    protected AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    public ServicesProvider getServicesProvider() {
        return this.servicesProvider;
    }

    public ObjectInstantiator getObjectInstantiator() {
        return this.objectInstantiator;
    }

    public SpecificationLoader getSpecificationLookup() {
        return this.specificationLookup;
    }

    public static enum IntrospectionState {
        NOT_INTROSPECTED,
        BEING_INTROSPECTED,
        INTROSPECTED;

    }

    private static class SubclassList {
        private final List<ObjectSpecification> classes = Lists.newArrayList();

        private SubclassList() {
        }

        public void addSubclass(ObjectSpecification subclass) {
            if (this.classes.contains(subclass)) {
                return;
            }
            this.classes.add(subclass);
        }

        public boolean hasSubclasses() {
            return !this.classes.isEmpty();
        }

        public List<ObjectSpecification> toList() {
            return Collections.unmodifiableList(this.classes);
        }
    }
}

